/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import ml.comet.experiment.impl.rest.RegistryModelItemDetails;
import ml.comet.experiment.registrymodel.ModelOverview;
import org.slf4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegistryModelDetailsResponse {
    private String registryModelId;
    private String workspaceId;
    private String modelName;
    private String description;
    private long numberOfVersions;
    @JsonProperty(value="isPublic")
    private boolean isPublic;
    private boolean isAutoGenerated;
    private boolean isMonitored;
    private List<RegistryModelItemDetails> versions;
    private String imagePath;
    private String userName;
    private long createdAt;
    private long lastUpdated;

    public ModelOverview toModelOverview(Logger logger) {
        ModelOverview model = new ModelOverview();
        model.setRegistryModelId(this.registryModelId);
        model.setWorkspaceId(this.workspaceId);
        model.setModelName(this.modelName);
        model.setDescription(this.description);
        model.setNumberOfVersions(this.numberOfVersions);
        model.setPublic(this.isPublic);
        model.setUserName(this.userName);
        if (this.createdAt > 0L) {
            model.setCreatedAt(Instant.ofEpochMilli(this.createdAt));
        }
        if (this.lastUpdated > 0L) {
            model.setLastUpdated(Instant.ofEpochMilli(this.lastUpdated));
        }
        if (this.versions != null) {
            List versions = this.versions.stream().collect(ArrayList::new, (versionOverviews, modelItemDetails) -> versionOverviews.add(modelItemDetails.toModelVersionOverview(logger)), ArrayList::addAll);
            model.setVersions(versions);
        }
        return model;
    }

    public RegistryModelDetailsResponse() {
    }

    public RegistryModelDetailsResponse(String registryModelId, String workspaceId, String modelName, String description, long numberOfVersions, boolean isPublic, boolean isAutoGenerated, boolean isMonitored, List<RegistryModelItemDetails> versions, String imagePath, String userName, long createdAt, long lastUpdated) {
        this.registryModelId = registryModelId;
        this.workspaceId = workspaceId;
        this.modelName = modelName;
        this.description = description;
        this.numberOfVersions = numberOfVersions;
        this.isPublic = isPublic;
        this.isAutoGenerated = isAutoGenerated;
        this.isMonitored = isMonitored;
        this.versions = versions;
        this.imagePath = imagePath;
        this.userName = userName;
        this.createdAt = createdAt;
        this.lastUpdated = lastUpdated;
    }

    public String getRegistryModelId() {
        return this.registryModelId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getDescription() {
        return this.description;
    }

    public long getNumberOfVersions() {
        return this.numberOfVersions;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isAutoGenerated() {
        return this.isAutoGenerated;
    }

    public boolean isMonitored() {
        return this.isMonitored;
    }

    public List<RegistryModelItemDetails> getVersions() {
        return this.versions;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setRegistryModelId(String registryModelId) {
        this.registryModelId = registryModelId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNumberOfVersions(long numberOfVersions) {
        this.numberOfVersions = numberOfVersions;
    }

    @JsonProperty(value="isPublic")
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setAutoGenerated(boolean isAutoGenerated) {
        this.isAutoGenerated = isAutoGenerated;
    }

    public void setMonitored(boolean isMonitored) {
        this.isMonitored = isMonitored;
    }

    public void setVersions(List<RegistryModelItemDetails> versions) {
        this.versions = versions;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryModelDetailsResponse)) {
            return false;
        }
        RegistryModelDetailsResponse other = (RegistryModelDetailsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfVersions() != other.getNumberOfVersions()) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        if (this.isAutoGenerated() != other.isAutoGenerated()) {
            return false;
        }
        if (this.isMonitored() != other.isMonitored()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getLastUpdated() != other.getLastUpdated()) {
            return false;
        }
        String this$registryModelId = this.getRegistryModelId();
        String other$registryModelId = other.getRegistryModelId();
        if (this$registryModelId == null ? other$registryModelId != null : !this$registryModelId.equals(other$registryModelId)) {
            return false;
        }
        String this$workspaceId = this.getWorkspaceId();
        String other$workspaceId = other.getWorkspaceId();
        if (this$workspaceId == null ? other$workspaceId != null : !this$workspaceId.equals(other$workspaceId)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<RegistryModelItemDetails> this$versions = this.getVersions();
        List<RegistryModelItemDetails> other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        String this$imagePath = this.getImagePath();
        String other$imagePath = other.getImagePath();
        if (this$imagePath == null ? other$imagePath != null : !this$imagePath.equals(other$imagePath)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryModelDetailsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $numberOfVersions = this.getNumberOfVersions();
        result = result * 59 + (int)($numberOfVersions >>> 32 ^ $numberOfVersions);
        result = result * 59 + (this.isPublic() ? 79 : 97);
        result = result * 59 + (this.isAutoGenerated() ? 79 : 97);
        result = result * 59 + (this.isMonitored() ? 79 : 97);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $lastUpdated = this.getLastUpdated();
        result = result * 59 + (int)($lastUpdated >>> 32 ^ $lastUpdated);
        String $registryModelId = this.getRegistryModelId();
        result = result * 59 + ($registryModelId == null ? 43 : $registryModelId.hashCode());
        String $workspaceId = this.getWorkspaceId();
        result = result * 59 + ($workspaceId == null ? 43 : $workspaceId.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<RegistryModelItemDetails> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        String $imagePath = this.getImagePath();
        result = result * 59 + ($imagePath == null ? 43 : $imagePath.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    public String toString() {
        return "RegistryModelDetailsResponse(registryModelId=" + this.getRegistryModelId() + ", workspaceId=" + this.getWorkspaceId() + ", modelName=" + this.getModelName() + ", description=" + this.getDescription() + ", numberOfVersions=" + this.getNumberOfVersions() + ", isPublic=" + this.isPublic() + ", isAutoGenerated=" + this.isAutoGenerated() + ", isMonitored=" + this.isMonitored() + ", versions=" + this.getVersions() + ", imagePath=" + this.getImagePath() + ", userName=" + this.getUserName() + ", createdAt=" + this.getCreatedAt() + ", lastUpdated=" + this.getLastUpdated() + ")";
    }
}

