/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    public static int unzipToFolder(ZipInputStream zis, Path targetFolder) throws IOException {
        int filesCount = 0;
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            Path targetDirResolved = targetFolder.resolve(zipEntry.getName());
            Path normalizedPath = targetDirResolved.normalize();
            if (!normalizedPath.startsWith(targetFolder)) {
                throw new IOException("Bad zip entry: " + zipEntry.getName());
            }
            boolean isFolder = zipEntry.getName().endsWith(File.separator);
            if (isFolder) {
                Files.createDirectories(normalizedPath, new FileAttribute[0]);
            } else {
                if (normalizedPath.getParent() != null && Files.notExists(normalizedPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(normalizedPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(zis, normalizedPath, StandardCopyOption.REPLACE_EXISTING);
                ++filesCount;
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        return filesCount;
    }
}

