/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.ArtifactException;
import ml.comet.experiment.artifact.AssetOverwriteStrategy;
import ml.comet.experiment.artifact.LoggedArtifactAsset;
import ml.comet.experiment.impl.LoggedArtifactImpl;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.RestApiUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggedArtifactAssetImpl
implements LoggedArtifactAsset {
    private final Logger logger = LoggerFactory.getLogger(LoggedArtifactAsset.class);
    private boolean remote;
    private String assetType;
    private String assetId;
    private String metadataJson;
    private String logicalPath;
    private Long fileSize;
    private String remoteUri;
    private String artifactId;
    private String artifactVersionId;
    private Map<String, Object> metadata;
    final LoggedArtifactImpl artifact;

    LoggedArtifactAssetImpl(LoggedArtifactImpl artifact) {
        this.artifact = artifact;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getArtifactVersionId() {
        return this.artifactVersionId;
    }

    @Override
    public Optional<Long> getSize() {
        if (this.fileSize != null) {
            return Optional.of(this.fileSize);
        }
        return Optional.empty();
    }

    @Override
    public Optional<URI> getLink() {
        if (StringUtils.isNotBlank((CharSequence)this.remoteUri)) {
            try {
                return Optional.of(new URI(this.remoteUri));
            }
            catch (URISyntaxException e) {
                this.logger.error("Failed to parse remote asset URI: {}", (Object)this.remoteUri, (Object)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (StringUtils.isNotBlank((CharSequence)this.metadataJson)) {
            try {
                this.metadata = RestApiUtils.metadataFromJson(this.metadataJson);
                return this.metadata;
            }
            catch (Throwable e) {
                this.logger.error("Failed to parse artifact asset metadata from JSON {}", (Object)this.metadataJson, (Object)e);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public ArtifactAsset download(Path dir) throws ArtifactException {
        return this.download(dir, AssetOverwriteStrategy.FAIL_IF_DIFFERENT);
    }

    @Override
    public ArtifactAsset download(Path dir, AssetOverwriteStrategy overwriteStrategy) throws ArtifactException {
        return this.download(dir, FileSystems.getDefault().getPath(this.logicalPath, new String[0]), overwriteStrategy);
    }

    @Override
    public ArtifactAsset download(@NonNull Path dir, @NonNull Path file, @NonNull AssetOverwriteStrategy overwriteStrategy) throws ArtifactException {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (overwriteStrategy == null) {
            throw new NullPointerException("overwriteStrategy is marked non-null but is null");
        }
        this.validateNotRemote();
        return this.artifact.downloadAsset(this, dir, file, overwriteStrategy);
    }

    @Override
    public void writeTo(OutputStream out) throws ArtifactException {
        this.validateNotRemote();
        this.artifact.writeAssetTo(this, out);
    }

    @Override
    public InputStream openStream() throws ArtifactException {
        this.validateNotRemote();
        return this.artifact.openAssetStream(this);
    }

    String artifactFullName() {
        return this.artifact.getFullName();
    }

    void validateNotRemote() {
        if (this.isRemote()) {
            throw new ArtifactException(LogMessages.getString("REMOTE_ASSET_CANNOT_BE_DOWNLOADED", this));
        }
    }

    public String toString() {
        return "LoggedArtifactAssetImpl(remote=" + this.isRemote() + ", assetType=" + this.getAssetType() + ", assetId=" + this.getAssetId() + ", logicalPath=" + this.getLogicalPath() + ", remoteUri=" + this.remoteUri + ", artifactFullName=" + this.artifactFullName() + ")";
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    @Override
    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    @Override
    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public void setMetadataJson(String metadataJson) {
        this.metadataJson = metadataJson;
    }

    public void setLogicalPath(String logicalPath) {
        this.logicalPath = logicalPath;
    }

    @Override
    public String getLogicalPath() {
        return this.logicalPath;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public void setRemoteUri(String remoteUri) {
        this.remoteUri = remoteUri;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersionId(String artifactVersionId) {
        this.artifactVersionId = artifactVersionId;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }
}

