/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vdurmont.semver4j.Semver;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.impl.LoggedArtifactImpl;
import ml.comet.experiment.impl.rest.ArtifactDto;
import ml.comet.experiment.impl.rest.ArtifactVersionState;
import ml.comet.experiment.impl.rest.BaseExperimentObject;
import ml.comet.experiment.impl.utils.CometUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ArtifactVersionDetail
extends BaseExperimentObject {
    String artifactVersionId;
    String artifactVersion;
    String owner;
    String createdFrom;
    Long sizeInBytes = 0L;
    String metadata;
    String note;
    Timestamp added;
    ArtifactVersionState state;
    List<String> tags;
    List<String> alias;
    ArtifactDto artifact;

    public LoggedArtifact copyToLoggedArtifact(LoggedArtifactImpl artifact) {
        artifact.setSemanticVersion(new Semver(this.artifactVersion));
        artifact.setArtifactId(this.artifact.getArtifactId());
        artifact.setArtifactVersionId(this.artifactVersionId);
        artifact.setExperimentKey(this.experimentKey);
        artifact.setSizeInBytes(this.sizeInBytes);
        artifact.setWorkspace(this.artifact.getWorkspaceName());
        artifact.setAliases((Set)CometUtils.setFromList(this.alias));
        artifact.setArtifactTags(CometUtils.setFromList(this.artifact.getTags()));
        artifact.setVersionTags((Set)CometUtils.setFromList(this.tags));
        artifact.setMetadataJson(this.metadata);
        return artifact;
    }

    public String getArtifactVersionId() {
        return this.artifactVersionId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getCreatedFrom() {
        return this.createdFrom;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getNote() {
        return this.note;
    }

    public Timestamp getAdded() {
        return this.added;
    }

    public ArtifactVersionState getState() {
        return this.state;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public ArtifactDto getArtifact() {
        return this.artifact;
    }

    public void setArtifactVersionId(String artifactVersionId) {
        this.artifactVersionId = artifactVersionId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedFrom(String createdFrom) {
        this.createdFrom = createdFrom;
    }

    public void setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setAdded(Timestamp added) {
        this.added = added;
    }

    public void setState(ArtifactVersionState state) {
        this.state = state;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    public void setArtifact(ArtifactDto artifact) {
        this.artifact = artifact;
    }

    @Override
    public String toString() {
        return "ArtifactVersionDetail(artifactVersionId=" + this.getArtifactVersionId() + ", artifactVersion=" + this.getArtifactVersion() + ", owner=" + this.getOwner() + ", createdFrom=" + this.getCreatedFrom() + ", sizeInBytes=" + this.getSizeInBytes() + ", metadata=" + this.getMetadata() + ", note=" + this.getNote() + ", added=" + this.getAdded() + ", state=" + (Object)((Object)this.getState()) + ", tags=" + this.getTags() + ", alias=" + this.getAlias() + ", artifact=" + this.getArtifact() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactVersionDetail)) {
            return false;
        }
        ArtifactVersionDetail other = (ArtifactVersionDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sizeInBytes = this.getSizeInBytes();
        Long other$sizeInBytes = other.getSizeInBytes();
        if (this$sizeInBytes == null ? other$sizeInBytes != null : !((Object)this$sizeInBytes).equals(other$sizeInBytes)) {
            return false;
        }
        String this$artifactVersionId = this.getArtifactVersionId();
        String other$artifactVersionId = other.getArtifactVersionId();
        if (this$artifactVersionId == null ? other$artifactVersionId != null : !this$artifactVersionId.equals(other$artifactVersionId)) {
            return false;
        }
        String this$artifactVersion = this.getArtifactVersion();
        String other$artifactVersion = other.getArtifactVersion();
        if (this$artifactVersion == null ? other$artifactVersion != null : !this$artifactVersion.equals(other$artifactVersion)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$createdFrom = this.getCreatedFrom();
        String other$createdFrom = other.getCreatedFrom();
        if (this$createdFrom == null ? other$createdFrom != null : !this$createdFrom.equals(other$createdFrom)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        Timestamp this$added = this.getAdded();
        Timestamp other$added = other.getAdded();
        if (this$added == null ? other$added != null : !((Object)this$added).equals(other$added)) {
            return false;
        }
        ArtifactVersionState this$state = this.getState();
        ArtifactVersionState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$alias = this.getAlias();
        List<String> other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
            return false;
        }
        ArtifactDto this$artifact = this.getArtifact();
        ArtifactDto other$artifact = other.getArtifact();
        return !(this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactVersionDetail;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sizeInBytes = this.getSizeInBytes();
        result = result * 59 + ($sizeInBytes == null ? 43 : ((Object)$sizeInBytes).hashCode());
        String $artifactVersionId = this.getArtifactVersionId();
        result = result * 59 + ($artifactVersionId == null ? 43 : $artifactVersionId.hashCode());
        String $artifactVersion = this.getArtifactVersion();
        result = result * 59 + ($artifactVersion == null ? 43 : $artifactVersion.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $createdFrom = this.getCreatedFrom();
        result = result * 59 + ($createdFrom == null ? 43 : $createdFrom.hashCode());
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        Timestamp $added = this.getAdded();
        result = result * 59 + ($added == null ? 43 : ((Object)$added).hashCode());
        ArtifactVersionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
        ArtifactDto $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
        return result;
    }

    public ArtifactVersionDetail(String artifactVersionId, String artifactVersion, String owner, String createdFrom, Long sizeInBytes, String metadata, String note, Timestamp added, ArtifactVersionState state, List<String> tags, List<String> alias, ArtifactDto artifact) {
        this.artifactVersionId = artifactVersionId;
        this.artifactVersion = artifactVersion;
        this.owner = owner;
        this.createdFrom = createdFrom;
        this.sizeInBytes = sizeInBytes;
        this.metadata = metadata;
        this.note = note;
        this.added = added;
        this.state = state;
        this.tags = tags;
        this.alias = alias;
        this.artifact = artifact;
    }

    public ArtifactVersionDetail() {
    }
}

