/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import ml.comet.experiment.impl.rest.ExperimentAssetLink;
import ml.comet.experiment.impl.rest.ExperimentModelResponse;
import ml.comet.experiment.registrymodel.ModelVersionOverview;
import org.slf4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegistryModelItemDetails {
    private String registryModelItemId;
    private ExperimentModelResponse experimentModel;
    private String version;
    private String comment;
    private List<String> stages;
    private List<ExperimentAssetLink> assets;
    private String userName;
    private long createdAt;
    private long lastUpdated;
    private String restApiUrl;

    public ModelVersionOverview toModelVersionOverview(Logger logger) {
        ModelVersionOverview model = new ModelVersionOverview();
        model.setRegistryModelItemId(this.registryModelItemId);
        model.setVersion(this.version);
        model.setComment(this.comment);
        model.setStages(this.stages);
        model.setUserName(this.userName);
        model.setRestApiUrl(this.restApiUrl);
        if (this.createdAt > 0L) {
            model.setCreatedAt(Instant.ofEpochMilli(this.createdAt));
        }
        if (this.lastUpdated > 0L) {
            model.setLastUpdated(Instant.ofEpochMilli(this.lastUpdated));
        }
        if (this.assets != null) {
            ArrayList loggedAssets = this.assets.stream().collect(ArrayList::new, (experimentAssets, assetLink) -> experimentAssets.add(assetLink.toExperimentAsset(logger)), ArrayList::addAll);
            model.setAssets(loggedAssets);
        }
        return model;
    }

    public String getRegistryModelItemId() {
        return this.registryModelItemId;
    }

    public ExperimentModelResponse getExperimentModel() {
        return this.experimentModel;
    }

    public String getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getStages() {
        return this.stages;
    }

    public List<ExperimentAssetLink> getAssets() {
        return this.assets;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public String getRestApiUrl() {
        return this.restApiUrl;
    }

    public void setRegistryModelItemId(String registryModelItemId) {
        this.registryModelItemId = registryModelItemId;
    }

    public void setExperimentModel(ExperimentModelResponse experimentModel) {
        this.experimentModel = experimentModel;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setStages(List<String> stages) {
        this.stages = stages;
    }

    public void setAssets(List<ExperimentAssetLink> assets) {
        this.assets = assets;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setRestApiUrl(String restApiUrl) {
        this.restApiUrl = restApiUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryModelItemDetails)) {
            return false;
        }
        RegistryModelItemDetails other = (RegistryModelItemDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getLastUpdated() != other.getLastUpdated()) {
            return false;
        }
        String this$registryModelItemId = this.getRegistryModelItemId();
        String other$registryModelItemId = other.getRegistryModelItemId();
        if (this$registryModelItemId == null ? other$registryModelItemId != null : !this$registryModelItemId.equals(other$registryModelItemId)) {
            return false;
        }
        ExperimentModelResponse this$experimentModel = this.getExperimentModel();
        ExperimentModelResponse other$experimentModel = other.getExperimentModel();
        if (this$experimentModel == null ? other$experimentModel != null : !((Object)this$experimentModel).equals(other$experimentModel)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<String> this$stages = this.getStages();
        List<String> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        List<ExperimentAssetLink> this$assets = this.getAssets();
        List<ExperimentAssetLink> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$restApiUrl = this.getRestApiUrl();
        String other$restApiUrl = other.getRestApiUrl();
        return !(this$restApiUrl == null ? other$restApiUrl != null : !this$restApiUrl.equals(other$restApiUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryModelItemDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        long $lastUpdated = this.getLastUpdated();
        result = result * 59 + (int)($lastUpdated >>> 32 ^ $lastUpdated);
        String $registryModelItemId = this.getRegistryModelItemId();
        result = result * 59 + ($registryModelItemId == null ? 43 : $registryModelItemId.hashCode());
        ExperimentModelResponse $experimentModel = this.getExperimentModel();
        result = result * 59 + ($experimentModel == null ? 43 : ((Object)$experimentModel).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<String> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        List<ExperimentAssetLink> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $restApiUrl = this.getRestApiUrl();
        result = result * 59 + ($restApiUrl == null ? 43 : $restApiUrl.hashCode());
        return result;
    }

    public String toString() {
        return "RegistryModelItemDetails(registryModelItemId=" + this.getRegistryModelItemId() + ", experimentModel=" + this.getExperimentModel() + ", version=" + this.getVersion() + ", comment=" + this.getComment() + ", stages=" + this.getStages() + ", assets=" + this.getAssets() + ", userName=" + this.getUserName() + ", createdAt=" + this.getCreatedAt() + ", lastUpdated=" + this.getLastUpdated() + ", restApiUrl=" + this.getRestApiUrl() + ")";
    }

    public RegistryModelItemDetails() {
    }

    public RegistryModelItemDetails(String registryModelItemId, ExperimentModelResponse experimentModel, String version, String comment, List<String> stages, List<ExperimentAssetLink> assets, String userName, long createdAt, long lastUpdated, String restApiUrl) {
        this.registryModelItemId = registryModelItemId;
        this.experimentModel = experimentModel;
        this.version = version;
        this.comment = comment;
        this.stages = stages;
        this.assets = assets;
        this.userName = userName;
        this.createdAt = createdAt;
        this.lastUpdated = lastUpdated;
        this.restApiUrl = restApiUrl;
    }
}

