/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.artifact.GetArtifactOptions;
import ml.comet.experiment.asset.Asset;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.ArtifactImpl;
import ml.comet.experiment.impl.RegistryModelImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.DownloadArtifactAssetOptions;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.rest.AddExperimentTagsRest;
import ml.comet.experiment.impl.rest.AddGraphRest;
import ml.comet.experiment.impl.rest.ArtifactRequest;
import ml.comet.experiment.impl.rest.ArtifactVersionState;
import ml.comet.experiment.impl.rest.ExperimentTimeRequest;
import ml.comet.experiment.impl.rest.GitMetadataRest;
import ml.comet.experiment.impl.rest.HtmlRest;
import ml.comet.experiment.impl.rest.LogOtherRest;
import ml.comet.experiment.impl.rest.MetricRest;
import ml.comet.experiment.impl.rest.OutputLine;
import ml.comet.experiment.impl.rest.OutputUpdate;
import ml.comet.experiment.impl.rest.ParameterRest;
import ml.comet.experiment.impl.rest.RegistryModelCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelNotesUpdateRequest;
import ml.comet.experiment.impl.rest.RegistryModelUpdateRequest;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.JsonUtils;
import ml.comet.experiment.model.GitMetaData;
import ml.comet.experiment.registrymodel.DownloadModelOptions;
import org.apache.commons.lang3.StringUtils;

public final class RestApiUtils {
    public static MetricRest createLogMetricRequest(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        MetricRest request = new MetricRest();
        request.setMetricName(metricName);
        request.setMetricValue(metricValue.toString());
        request.setStep(context.getStep());
        request.setEpoch(context.getEpoch());
        request.setTimestamp(System.currentTimeMillis());
        request.setContext(context.getContext());
        return request;
    }

    public static ParameterRest createLogParamRequest(@NonNull String parameterName, @NonNull Object paramValue, @NonNull ExperimentContext context) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        ParameterRest request = new ParameterRest();
        request.setParameterName(parameterName);
        request.setParameterValue(paramValue.toString());
        request.setStep(context.getStep());
        request.setTimestamp(System.currentTimeMillis());
        request.setContext(context.getContext());
        return request;
    }

    public static OutputUpdate createLogLineRequest(@NonNull String line, long offset, boolean stderr, String context) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        OutputLine outputLine = new OutputLine();
        outputLine.setOutput(line);
        outputLine.setStderr(stderr);
        outputLine.setLocalTimestamp(System.currentTimeMillis());
        outputLine.setOffset(offset);
        OutputUpdate outputUpdate = new OutputUpdate();
        outputUpdate.setRunContext(context);
        outputUpdate.setOutputLines(Collections.singletonList(outputLine));
        return outputUpdate;
    }

    public static HtmlRest createLogHtmlRequest(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        HtmlRest request = new HtmlRest();
        request.setHtml(html);
        request.setOverride(override);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    public static LogOtherRest createLogOtherRequest(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        LogOtherRest request = new LogOtherRest();
        request.setKey(key);
        request.setValue(value.toString());
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    public static AddExperimentTagsRest createTagRequest(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        AddExperimentTagsRest request = new AddExperimentTagsRest();
        request.setAddedTags(Collections.singletonList(tag));
        return request;
    }

    public static AddGraphRest createGraphRequest(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        AddGraphRest request = new AddGraphRest();
        request.setGraph(graph);
        return request;
    }

    public static ExperimentTimeRequest createLogStartTimeRequest(long startTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setStartTimeMillis(startTimeMillis);
        return request;
    }

    public static ExperimentTimeRequest createLogEndTimeRequest(long endTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setEndTimeMillis(endTimeMillis);
        return request;
    }

    public static GitMetadataRest createGitMetadataRequest(GitMetaData metaData) {
        GitMetadataRest g = new GitMetadataRest();
        g.setUser(metaData.getUser());
        g.setOrigin(metaData.getOrigin());
        g.setBranch(metaData.getBranch());
        g.setParent(metaData.getParent());
        g.setRoot(metaData.getRoot());
        return g;
    }

    public static ArtifactRequest createArtifactUpsertRequest(ArtifactImpl artifact) {
        ArtifactRequest r = new ArtifactRequest();
        r.setArtifactName(artifact.getName());
        r.setArtifactType(artifact.getType());
        if (artifact.getSemanticVersion() != null) {
            r.setVersion(artifact.getSemanticVersion().getValue());
        }
        if (artifact.getAliases() != null && artifact.getAliases().size() > 0) {
            r.setAlias(artifact.getAliases().toArray(new String[0]));
        }
        if (artifact.getVersionTags() != null && artifact.getVersionTags().size() > 0) {
            r.setVersionTags(artifact.getVersionTags().toArray(new String[0]));
        }
        if (artifact.getMetadata() != null) {
            r.setVersionMetadata(JsonUtils.toJson(artifact.getMetadata()));
        }
        return r;
    }

    public static ArtifactRequest createArtifactVersionStateRequest(String artifactVersionId, ArtifactVersionState state) {
        ArtifactRequest r = new ArtifactRequest();
        r.setArtifactVersionId(artifactVersionId);
        r.setState(state);
        return r;
    }

    public static RegistryModelCreateRequest createRegistryModelCreateRequest(RegistryModelImpl model) {
        RegistryModelCreateRequest request = new RegistryModelCreateRequest();
        request.setExperimentModelId(model.getExperimentModelId());
        request.setRegistryModelName(model.getRegistryName());
        request.setVersion(model.getVersion());
        request.setPublic(model.isPublic());
        request.setComment(model.getComment());
        request.setDescription(model.getDescription());
        request.setStages(model.getStages());
        return request;
    }

    public static RegistryModelItemCreateRequest createRegistryModelItemCreateRequest(RegistryModelImpl model) {
        RegistryModelItemCreateRequest request = new RegistryModelItemCreateRequest();
        request.setExperimentModelId(model.getExperimentModelId());
        request.setRegistryModelName(model.getRegistryName());
        request.setVersion(model.getVersion());
        request.setComment(model.getComment());
        request.setStages(model.getStages());
        return request;
    }

    public static RegistryModelNotesUpdateRequest createRegistryModelNotesUpdateRequest(String notes, String registryName, String workspace) {
        return new RegistryModelNotesUpdateRequest(notes, registryName, workspace);
    }

    public static RegistryModelUpdateRequest createRegistryModelUpdateRequest(String registryModelName, String description, Boolean isPublic) {
        RegistryModelUpdateRequest request = new RegistryModelUpdateRequest();
        request.setRegistryModelName(registryModelName);
        request.setDescription(description);
        request.setIsPublic(isPublic);
        return request;
    }

    public static Map<String, Object> metadataFromJson(String json) {
        return JsonUtils.fromJson(json, new TypeReference<Map<String, Object>>(){});
    }

    public static Map<QueryParamName, String> downloadModelParams(@NonNull String workspace, @NonNull String registryName, @NonNull DownloadModelOptions options) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.WORKSPACE_NAME, workspace);
        queryParams.put(QueryParamName.MODEL_NAME, registryName);
        if (StringUtils.isNotBlank((CharSequence)options.getVersion())) {
            queryParams.put(QueryParamName.VERSION, options.getVersion());
        }
        if (StringUtils.isNotBlank((CharSequence)options.getStage())) {
            queryParams.put(QueryParamName.STAGE, options.getStage());
        }
        return queryParams;
    }

    public static Map<QueryParamName, String> assetQueryParameters(@NonNull AssetImpl asset, @NonNull String experimentKey) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.TYPE, asset.getType());
        CometUtils.putNotNull(queryParams, QueryParamName.OVERWRITE, asset.getOverwrite());
        CometUtils.putNotNull(queryParams, QueryParamName.FILE_NAME, asset.getLogicalPath());
        CometUtils.putNotNull(queryParams, QueryParamName.EXTENSION, asset.getFileExtension());
        if (asset.getExperimentContext().isPresent()) {
            ExperimentContext context = asset.getExperimentContext().get();
            CometUtils.putNotNull(queryParams, QueryParamName.CONTEXT, context.getContext());
            CometUtils.putNotNull(queryParams, QueryParamName.STEP, context.getStep());
            CometUtils.putNotNull(queryParams, QueryParamName.EPOCH, context.getEpoch());
        }
        if (asset.getGroupingName().isPresent()) {
            queryParams.put(QueryParamName.GROUPING_NAME, asset.getGroupingName().get());
        }
        return queryParams;
    }

    public static Map<FormParamName, Object> assetFormParameters(@NonNull Asset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        HashMap<FormParamName, Object> map = new HashMap<FormParamName, Object>();
        if (asset.getMetadata() != null) {
            map.put(FormParamName.METADATA, JsonUtils.toJson(asset.getMetadata()));
        }
        return map;
    }

    public static Map<QueryParamName, String> artifactVersionDetailsParams(@NonNull GetArtifactOptions options, @NonNull String experimentKey) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        Map<QueryParamName, String> queryParams = RestApiUtils.artifactVersionParams(options);
        queryParams.put(QueryParamName.CONSUMER_EXPERIMENT_KEY, options.getConsumerExperimentKey());
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.PROJECT, options.getProject());
        queryParams.put(QueryParamName.VERSION_OR_ALIAS, options.getVersionOrAlias());
        return queryParams;
    }

    public static Map<QueryParamName, String> artifactVersionFilesParams(@NonNull GetArtifactOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return RestApiUtils.artifactVersionParams(options);
    }

    static Map<QueryParamName, String> artifactVersionParams(@NonNull GetArtifactOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.ALIAS, options.getAlias());
        queryParams.put(QueryParamName.ARTIFACT_ID, options.getArtifactId());
        queryParams.put(QueryParamName.ARTIFACT_NAME, options.getArtifactName());
        queryParams.put(QueryParamName.VERSION_ID, options.getVersionId());
        queryParams.put(QueryParamName.VERSION, options.getVersion());
        queryParams.put(QueryParamName.WORKSPACE, options.getWorkspace());
        return queryParams;
    }

    public static Map<QueryParamName, String> artifactDownloadAssetParams(@NonNull DownloadArtifactAssetOptions options, @NonNull String experimentKey) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.ASSET_ID, options.getAssetId());
        queryParams.put(QueryParamName.ARTIFACT_VERSION_ID, options.getArtifactVersionId());
        return queryParams;
    }

    private RestApiUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

