/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.registrymodel;

import com.vdurmont.semver4j.Semver;
import ml.comet.experiment.impl.resources.LogMessages;

public class DownloadModelOptions {
    private Semver semver;
    private String stage;
    private boolean expand;

    private DownloadModelOptions() {
    }

    public String getVersion() {
        if (this.semver != null) {
            return this.semver.getValue();
        }
        return null;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public String getStage() {
        return this.stage;
    }

    public static DownloadModelOptionsBuilder Op() {
        return new DownloadModelOptionsBuilder();
    }

    public static final class DownloadModelOptionsBuilder {
        final DownloadModelOptions options = new DownloadModelOptions();
        Boolean expand = true;

        private DownloadModelOptionsBuilder() {
        }

        public DownloadModelOptionsBuilder withVersion(String version) {
            this.options.semver = new Semver(version);
            return this;
        }

        public DownloadModelOptionsBuilder withStage(String stage) {
            this.options.stage = stage;
            return this;
        }

        public DownloadModelOptionsBuilder withExpand(boolean expand) {
            this.expand = expand;
            return this;
        }

        public DownloadModelOptions build() throws IllegalArgumentException {
            if (this.options.stage != null && this.options.semver != null) {
                throw new IllegalArgumentException(LogMessages.getString("VERSION_AND_STAGE_SET_DOWNLOAD_MODEL"));
            }
            this.options.expand = this.expand;
            return this.options;
        }
    }
}

