/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import java.io.File;
import java.util.Optional;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.builder.ApiExperimentBuilder;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.utils.ConfigUtils;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExperiment
extends BaseExperiment {
    private final String baseUrl;
    private final int maxAuthRetries;
    private final String apiKey;
    private final String experimentKey;
    private final Connection connection;
    private Logger logger = LoggerFactory.getLogger(ApiExperiment.class);

    private ApiExperiment(String apiKey, String experimentKey, Logger logger, String baseUrl, int maxAuthRetries) {
        this.apiKey = apiKey;
        this.experimentKey = experimentKey;
        if (logger != null) {
            this.logger = logger;
        }
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
    }

    public ApiExperiment(String experimentKey) {
        this.experimentKey = experimentKey;
        this.apiKey = ConfigUtils.getApiKey().orElse(null);
        this.baseUrl = ConfigUtils.getBaseUrlOrDefault();
        this.maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
    }

    public static ApiExperimentBuilderImpl builder(String experimentKey) {
        return new ApiExperimentBuilderImpl(experimentKey);
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getContext() {
        return "";
    }

    @Override
    public String getWorkspaceName() {
        return this.getMetadata().getWorkspaceName();
    }

    @Override
    public String getProjectName() {
        return this.getMetadata().getProjectName();
    }

    @Override
    public String getExperimentName() {
        return this.getMetadata().getExperimentName();
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        if (StringUtils.isEmpty((CharSequence)this.experimentKey)) {
            return Optional.empty();
        }
        HttpUrl.Builder builder = HttpUrl.get((String)this.baseUrl).newBuilder();
        builder.addPathSegment(this.getWorkspaceName());
        builder.addPathSegment(this.getProjectName());
        builder.addPathSegment(this.experimentKey);
        String link = builder.build().toString();
        return Optional.of(link);
    }

    public static class ApiExperimentBuilderImpl
    implements ApiExperimentBuilder {
        private final String experimentKey;
        private String apiKey;
        private Logger logger;
        private String baseUrl;
        private int maxAuthRetries;

        private ApiExperimentBuilderImpl(String experimentKey) {
            this.experimentKey = experimentKey;
            this.apiKey = ConfigUtils.getApiKey().orElse(null);
            this.baseUrl = ConfigUtils.getBaseUrlOrDefault();
            this.maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();
        }

        @Override
        public ApiExperimentBuilderImpl withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withConfig(File overrideConfig) {
            Config config = ConfigUtils.getConfigFromFile(overrideConfig);
            this.apiKey = config.getString("apiKey");
            this.baseUrl = config.getString("url");
            this.maxAuthRetries = config.getInt("maxAuthRetries");
            return this;
        }

        @Override
        public ApiExperiment build() {
            return new ApiExperiment(this.apiKey, this.experimentKey, this.logger, this.baseUrl, this.maxAuthRetries);
        }
    }
}

