/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.builder.OnlineExperimentBuilder;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.log.StdOutLogger;
import ml.comet.experiment.model.CreateExperimentRequest;
import ml.comet.experiment.model.CreateExperimentResponse;
import ml.comet.experiment.model.OutputLine;
import ml.comet.experiment.model.OutputUpdate;
import ml.comet.experiment.utils.ConfigUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineExperimentImpl
extends BaseExperiment
implements OnlineExperiment {
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final String projectName;
    private final String workspaceName;
    private final String apiKey;
    private final String baseUrl;
    private final int maxAuthRetries;
    private Logger logger = LoggerFactory.getLogger(OnlineExperimentImpl.class);
    private Connection connection;
    private String experimentKey;
    private String experimentLink;
    private String experimentName;
    private StdOutLogger stdOutLogger;
    private StdOutLogger stdErrLogger;
    private boolean interceptStdout;
    private ScheduledFuture pingStatusFuture;
    private long step = 0L;
    private long epoch = 0L;
    private String context = "";

    private OnlineExperimentImpl(String apiKey, String projectName, String workspaceName, String experimentName, String experimentKey, Logger logger, boolean interceptStdout, String baseUrl, int maxAuthRetries) {
        this.projectName = projectName;
        this.workspaceName = workspaceName;
        this.apiKey = apiKey;
        this.experimentName = experimentName;
        this.experimentKey = experimentKey;
        this.interceptStdout = interceptStdout;
        if (logger != null) {
            this.logger = logger;
        }
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        this.initializeExperiment();
    }

    public OnlineExperimentImpl() {
        this.projectName = ConfigUtils.getProjectNameOrThrow();
        this.workspaceName = ConfigUtils.getWorkspaceNameOrThrow();
        this.apiKey = ConfigUtils.getApiKeyOrThrow();
        this.baseUrl = ConfigUtils.getBaseUrlOrDefault();
        this.maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();
        this.initializeExperiment();
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    public static OnlineExperimentBuilderImpl builder() {
        return new OnlineExperimentBuilderImpl();
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void end() {
        if (this.pingStatusFuture != null) {
            this.pingStatusFuture.cancel(true);
            this.pingStatusFuture = null;
        }
    }

    @Override
    public void setInterceptStdout() throws IOException {
        if (!this.interceptStdout) {
            this.interceptStdout = true;
            this.captureStdout();
        }
    }

    @Override
    public void stopInterceptStdout() {
        if (this.stdOutLogger != null) {
            this.stdOutLogger.stop();
            this.stdOutLogger = null;
            this.interceptStdout = false;
        }
        if (this.stdErrLogger != null) {
            this.stdErrLogger.stop();
            this.stdErrLogger = null;
        }
    }

    @Override
    public void logLine(String line, long offset, boolean stderr) {
        if (this.getExperimentKey() == null) {
            return;
        }
        OutputUpdate outputUpdate = this.getLogLineRequest(line, offset, stderr);
        this.getConnection().sendPostAsync(outputUpdate, "/api/rest/v2/write/experiment/output");
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    @Override
    public void nextStep() {
        ++this.step;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    @Override
    public void nextEpoch() {
        ++this.epoch;
    }

    @Override
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        return Optional.ofNullable(this.experimentLink);
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step) {
        this.logMetric(metricName, metricValue, step, this.epoch);
    }

    @Override
    public void logMetric(String metricName, Object metricValue) {
        this.logMetric(metricName, metricValue, this.step, this.epoch);
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step, long epoch) {
        this.setStep(step);
        this.setEpoch(epoch);
        super.logMetric(metricName, metricValue, step, epoch);
    }

    @Override
    public void logParameter(String parameterName, Object paramValue) {
        this.logParameter(parameterName, paramValue, this.step);
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, long step) {
        this.setStep(step);
        super.logParameter(parameterName, paramValue, step);
    }

    @Override
    public void uploadAsset(File asset, String fileName, boolean overwrite, long step) {
        super.uploadAsset(asset, fileName, overwrite, step, this.epoch);
    }

    @Override
    public void uploadAsset(File asset, boolean overwrite) {
        this.uploadAsset(asset, asset.getName(), overwrite);
    }

    @Override
    public void uploadAsset(File asset, String fileName, boolean overwrite) {
        super.uploadAsset(asset, fileName, overwrite, this.step, this.epoch);
    }

    private void initializeExperiment() {
        this.validateInitialParams();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
        this.setupStdOutIntercept();
        this.registerExperiment();
    }

    private void validateInitialParams() {
        if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("Apikey is not specified!");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.experimentKey)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.projectName)) {
            throw new IllegalArgumentException("ProjectName is not specified!");
        }
        if (StringUtils.isEmpty((CharSequence)this.workspaceName)) {
            throw new IllegalArgumentException("Workspace name is not specified!");
        }
    }

    private void setupStdOutIntercept() {
        if (this.interceptStdout) {
            try {
                this.captureStdout();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerExperiment() {
        if (this.experimentKey != null) {
            this.logger.debug("Not registering a new experiment.  Using experiment key {}", (Object)this.experimentKey);
            return;
        }
        CreateExperimentRequest request = new CreateExperimentRequest(this.workspaceName, this.projectName, this.experimentName);
        String body = JsonUtils.toJson(request);
        this.connection.sendPost(body, "/api/rest/v2/write/experiment/create", true).ifPresent(response -> {
            CreateExperimentResponse result = JsonUtils.fromJson(response, CreateExperimentResponse.class);
            this.experimentKey = result.getExperimentKey();
            this.experimentLink = result.getLink();
            this.logger.info("Experiment is live on comet.ml " + this.getExperimentUrl());
            this.pingStatusFuture = scheduledExecutorService.scheduleAtFixedRate(new StatusPing(this), 1L, 3L, TimeUnit.SECONDS);
        });
        if (this.experimentKey == null) {
            throw new CometGeneralException("Failed to register onlineExperiment with Comet ML");
        }
    }

    private String getExperimentUrl() {
        return this.experimentLink != null ? this.experimentLink : "";
    }

    private void captureStdout() throws IOException {
        this.stdOutLogger = StdOutLogger.createStdoutLogger(this);
        this.stdErrLogger = StdOutLogger.createStderrLogger(this);
    }

    protected void pingStatus() {
        if (this.experimentKey == null) {
            return;
        }
        this.logger.debug("pingStatus");
        this.connection.sendGet("/api/rest/v2/write/experiment/set-status", Collections.singletonMap("experimentKey", this.experimentKey));
    }

    private OutputUpdate getLogLineRequest(String line, long offset, boolean stderr) {
        OutputLine outputLine = new OutputLine();
        outputLine.setOutput(line);
        outputLine.setStderr(stderr);
        outputLine.setLocalTimestamp(System.currentTimeMillis());
        outputLine.setOffset(offset);
        OutputUpdate outputUpdate = new OutputUpdate();
        outputUpdate.setExperimentKey(this.getExperimentKey());
        outputUpdate.setRunContext(this.context);
        outputUpdate.setOutputLines(Collections.singletonList(outputLine));
        return outputUpdate;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int getMaxAuthRetries() {
        return this.maxAuthRetries;
    }

    public StdOutLogger getStdOutLogger() {
        return this.stdOutLogger;
    }

    public StdOutLogger getStdErrLogger() {
        return this.stdErrLogger;
    }

    public boolean isInterceptStdout() {
        return this.interceptStdout;
    }

    public ScheduledFuture getPingStatusFuture() {
        return this.pingStatusFuture;
    }

    static class StatusPing
    implements Runnable {
        OnlineExperimentImpl onlineExperiment;

        StatusPing(OnlineExperimentImpl onlineExperiment) {
            this.onlineExperiment = onlineExperiment;
        }

        @Override
        public void run() {
            this.onlineExperiment.pingStatus();
        }
    }

    public static class OnlineExperimentBuilderImpl
    implements OnlineExperimentBuilder {
        private String projectName;
        private String workspace;
        private String apiKey;
        private String baseUrl;
        private int maxAuthRetries = -1;
        private String experimentName;
        private String experimentKey;
        private Logger logger;
        private boolean interceptStdout = false;

        private OnlineExperimentBuilderImpl() {
        }

        @Override
        public OnlineExperimentBuilderImpl withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withWorkspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withMaxAuthRetries(int maxAuthRetries) {
            this.maxAuthRetries = maxAuthRetries;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withUrlOverride(String urlOverride) {
            this.baseUrl = urlOverride;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withExperimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withExistingExperimentKey(String experimentKey) {
            this.experimentKey = experimentKey;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withConfig(File overrideConfig) {
            ConfigUtils.setOverrideConfig(overrideConfig);
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl interceptStdout() {
            this.interceptStdout = true;
            return this;
        }

        @Override
        public OnlineExperimentImpl build() {
            if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
                this.apiKey = ConfigUtils.getApiKey().orElse(null);
            }
            if (StringUtils.isEmpty((CharSequence)this.projectName)) {
                this.projectName = ConfigUtils.getProjectName().orElse(null);
            }
            if (StringUtils.isEmpty((CharSequence)this.workspace)) {
                this.workspace = ConfigUtils.getWorkspaceName().orElse(null);
            }
            if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
                this.baseUrl = ConfigUtils.getBaseUrlOrDefault();
            }
            if (this.maxAuthRetries == -1) {
                this.maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();
            }
            return new OnlineExperimentImpl(this.apiKey, this.projectName, this.workspace, this.experimentName, this.experimentKey, this.logger, this.interceptStdout, this.baseUrl, this.maxAuthRetries);
        }
    }
}

