/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.log;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.log.CopyOutputStream;

public class StdOutLogger
implements Runnable {
    static AtomicLong offset = new AtomicLong();
    PrintStream original;
    OnlineExperiment experiment;
    BufferedReader reader;
    boolean stdOut;

    private StdOutLogger(PrintStream original, OnlineExperiment experiment, BufferedReader reader, boolean stdOut) {
        this.original = original;
        this.experiment = experiment;
        this.reader = reader;
        this.stdOut = stdOut;
    }

    @Override
    public void run() {
        try {
            while (true) {
                String line = this.reader.readLine();
                this.experiment.logLine(line, offset.incrementAndGet(), !this.stdOut);
            }
        }
        catch (IOException ex) {
            return;
        }
    }

    public void stop() {
        if (this.stdOut) {
            System.setOut(this.original);
        } else {
            System.setErr(this.original);
        }
    }

    public static StdOutLogger createStdoutLogger(OnlineExperiment experiment) throws IOException {
        return StdOutLogger.createLogger(experiment, System.out, true);
    }

    public static StdOutLogger createStderrLogger(OnlineExperiment experiment) throws IOException {
        return StdOutLogger.createLogger(experiment, System.err, false);
    }

    private static StdOutLogger createLogger(OnlineExperiment experiment, PrintStream original, boolean stdOut) throws IOException {
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        CopyOutputStream copyStream = new CopyOutputStream(original, out);
        PrintStream replacement = new PrintStream(copyStream);
        if (stdOut) {
            System.setOut(replacement);
        } else {
            System.setErr(replacement);
        }
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(in)));
        StdOutLogger logger = new StdOutLogger(original, experiment, stdoutReader, stdOut);
        Thread loggerThread = new Thread(logger);
        loggerThread.start();
        return logger;
    }
}

