/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.utils;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Optional;
import ml.comet.experiment.env.EnvironmentVariableExtractor;

public final class ConfigUtils {
    private static Optional<Config> defaultConfig = Optional.empty();
    private static Optional<Config> overrideConfig = Optional.empty();

    public static void setDefaultConfig() {
        try {
            Config config = ConfigFactory.load().getConfig("comet");
            defaultConfig = Optional.of(config);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public static void setOverrideConfig(File configFile) {
        Config config = ConfigFactory.parseFile((File)configFile).getConfig("comet");
        overrideConfig = Optional.of(config);
    }

    public static void clearOverrideConfig() {
        overrideConfig = Optional.empty();
    }

    public static void setDefaultConfig(File configFile) {
        Config config = ConfigFactory.parseFile((File)configFile).getConfig("comet");
        defaultConfig = Optional.of(config);
    }

    public static String getApiKeyOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_API_KEY", "apiKey");
    }

    public static Optional<String> getApiKey() {
        return ConfigUtils.getValueFromSystem("COMET_API_KEY", "apiKey");
    }

    public static String getProjectNameOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_PROJECT_NAME", "project");
    }

    public static Optional<String> getProjectName() {
        return ConfigUtils.getValueFromSystem("COMET_PROJECT_NAME", "project");
    }

    public static String getWorkspaceNameOrThrow() {
        return ConfigUtils.getValueFromSystemOrThrow("COMET_WORKSPACE_NAME", "workspace");
    }

    public static Optional<String> getWorkspaceName() {
        return ConfigUtils.getValueFromSystem("COMET_WORKSPACE_NAME", "workspace");
    }

    public static String getBaseUrlOrDefault() {
        return ConfigUtils.getValueFromSystem("COMET_BASE_URL", "url").orElse("https://www.comet.ml");
    }

    public static int getMaxAuthRetriesOrDefault() {
        return ConfigUtils.getValueFromSystem("COMET_MAX_AUTH_RETRIES", "maxAuthRetries").map(Integer::parseInt).orElse(4);
    }

    public static Config getConfigFromFile(File configFile) {
        return ConfigFactory.parseFile((File)configFile);
    }

    private static String getValueFromSystemOrThrow(String envVarName, String configValueName) {
        return ConfigUtils.getValueFromSystem(envVarName, configValueName).orElseThrow(() -> new IllegalStateException("No parameter with name " + configValueName + " found! Please specify it in env vars or config"));
    }

    private static Optional<String> getValueFromSystem(String envVarName, String configValueName) {
        Optional<String> envVariable = EnvironmentVariableExtractor.getEnvVariable(envVarName);
        if (envVariable.isPresent()) {
            return envVariable;
        }
        if (overrideConfig.isPresent() && overrideConfig.get().hasPath(configValueName)) {
            return overrideConfig.map(x -> x.getString(configValueName));
        }
        if (defaultConfig.isPresent() && defaultConfig.get().hasPath(configValueName)) {
            return defaultConfig.map(x -> x.getString(configValueName));
        }
        return Optional.empty();
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ConfigUtils.setDefaultConfig();
    }
}

