/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.builder.ApiExperimentBuilder;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.utils.ConfigUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiExperiment
extends BaseExperiment {
    private final String baseUrl;
    private final String experimentKey;
    private final Connection connection;
    private Logger logger = LoggerFactory.getLogger(ApiExperiment.class);

    private ApiExperiment(String apiKey, String anExperimentKey, Logger logger, String baseUrl, int maxAuthRetries) {
        this.experimentKey = anExperimentKey;
        if (logger != null) {
            this.logger = logger;
        }
        this.baseUrl = baseUrl;
        this.connection = ConnectionInitializer.initConnection(apiKey, this.baseUrl, maxAuthRetries, this.logger);
    }

    public static ApiExperimentBuilderImpl builder(@NonNull String experimentKey) {
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        return new ApiExperimentBuilderImpl(experimentKey);
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getContext() {
        return "";
    }

    @Override
    public String getWorkspaceName() {
        return this.getMetadata().getWorkspaceName();
    }

    @Override
    public String getProjectName() {
        return this.getMetadata().getProjectName();
    }

    @Override
    public String getExperimentName() {
        return this.getMetadata().getExperimentName();
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        if (StringUtils.isEmpty((CharSequence)this.experimentKey)) {
            return Optional.empty();
        }
        String url = String.format("%s/%s/%s/%s", this.baseUrl, this.getWorkspaceName(), this.getProjectName(), this.experimentKey);
        try {
            URI uri = URI.create(url);
            return Optional.of(uri.toString());
        }
        catch (Exception ex) {
            this.logger.error("failed to build experiment link", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static final class ApiExperimentBuilderImpl
    implements ApiExperimentBuilder {
        private final String experimentKey;
        private String apiKey;
        private Logger logger;
        private String baseUrl;
        private int maxAuthRetries;

        private ApiExperimentBuilderImpl(String anExperimentKey) {
            this.experimentKey = anExperimentKey;
            this.apiKey = ConfigUtils.getApiKey().orElse(null);
            this.baseUrl = ConfigUtils.getBaseUrlOrDefault();
            this.maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();
        }

        @Override
        public ApiExperimentBuilderImpl withApiKey(@NonNull String anApiKey) {
            if (anApiKey == null) {
                throw new NullPointerException("anApiKey is marked non-null but is null");
            }
            this.apiKey = anApiKey;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        @Override
        public ApiExperimentBuilderImpl withConfig(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            Config config = ConfigUtils.getConfigFromFile(overrideConfig);
            this.apiKey = config.getString("apiKey");
            this.baseUrl = config.getString("url");
            this.maxAuthRetries = config.getInt("maxAuthRetries");
            return this;
        }

        @Override
        public ApiExperiment build() {
            return new ApiExperiment(this.apiKey, this.experimentKey, this.logger, this.baseUrl, this.maxAuthRetries);
        }
    }
}

