/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import ml.comet.experiment.Experiment;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.model.AddGraphRest;
import ml.comet.experiment.model.AddTagsToExperimentRest;
import ml.comet.experiment.model.CreateGitMetadata;
import ml.comet.experiment.model.ExperimentAssetLink;
import ml.comet.experiment.model.ExperimentAssetListResponse;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.ExperimentTimeRequest;
import ml.comet.experiment.model.GetGraphResponse;
import ml.comet.experiment.model.GetHtmlResponse;
import ml.comet.experiment.model.GetOutputResponse;
import ml.comet.experiment.model.GitMetadataRest;
import ml.comet.experiment.model.HtmlRest;
import ml.comet.experiment.model.LogOtherRest;
import ml.comet.experiment.model.MetricRest;
import ml.comet.experiment.model.MinMaxResponse;
import ml.comet.experiment.model.ParameterRest;
import ml.comet.experiment.model.TagsResponse;
import ml.comet.experiment.model.ValueMinMaxDto;
import ml.comet.experiment.utils.ConfigUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.slf4j.Logger;

public abstract class BaseExperiment
implements Experiment {
    protected abstract String getContext();

    protected abstract Connection getConnection();

    protected abstract Logger getLogger();

    @Override
    public void setExperimentName(@NonNull String experimentName) {
        if (experimentName == null) {
            throw new NullPointerException("experimentName is marked non-null but is null");
        }
        this.logOther("Name", experimentName);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, long step, long epoch) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logMetric {} = {}, step: {}, epoch: {}", new Object[]{metricName, metricValue, step, epoch});
        }
        this.validateExperimentKeyPresent();
        MetricRest request = this.getLogMetricRequest(metricName, metricValue, step, epoch);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/metric");
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue, long step) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logParameter {} = {}, step: {}", new Object[]{parameterName, paramValue, step});
        }
        this.validateExperimentKeyPresent();
        ParameterRest request = this.getLogParameterRequest(parameterName, paramValue, step);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/parameter");
    }

    @Override
    public void logHtml(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logHtml {}, override: {}", (Object)html, (Object)override);
        }
        this.validateExperimentKeyPresent();
        HtmlRest request = this.getLogHtmlRequest(html, override);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/html");
    }

    @Override
    public void logCode(@NonNull String code, final @NonNull String fileName) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log raw source code, file name: {}", (Object)fileName);
        }
        this.validateExperimentKeyPresent();
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", fileName);
                this.put("context", BaseExperiment.this.getContext());
                this.put("type", "source_code");
                this.put("overwrite", Boolean.toString(false));
            }
        };
        this.getConnection().sendPostAsync(code.getBytes(StandardCharsets.UTF_8), "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)params).toCompletableFuture().exceptionally(t -> {
            this.getLogger().error("failed to log raw source code with file name {}", (Object)fileName, t);
            return null;
        });
    }

    @Override
    public void logCode(final @NonNull File asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log source code from file {}", (Object)asset.getName());
        }
        this.validateExperimentKeyPresent();
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", asset.getName());
                this.put("context", BaseExperiment.this.getContext());
                this.put("type", "source_code");
                this.put("overwrite", Boolean.toString(false));
            }
        };
        this.getConnection().sendPostAsync(asset, "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)params).toCompletableFuture().exceptionally(t -> {
            this.getLogger().error("failed to log source code from file {}", (Object)asset, t);
            return null;
        });
    }

    @Override
    public void logOther(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOther {} {}", (Object)key, value);
        }
        this.validateExperimentKeyPresent();
        LogOtherRest request = this.getLogOtherRequest(key, value);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/log-other");
    }

    @Override
    public void addTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logTag {}", (Object)tag);
        }
        this.validateExperimentKeyPresent();
        AddTagsToExperimentRest request = this.getTagRequest(tag);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/tags");
    }

    @Override
    public void logGraph(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOther {}", (Object)graph);
        }
        this.validateExperimentKeyPresent();
        AddGraphRest request = this.getGraphRequest(graph);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/graph");
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logStartTime {}", (Object)startTimeMillis);
        }
        this.validateExperimentKeyPresent();
        ExperimentTimeRequest request = this.getLogStartTimeRequest(startTimeMillis);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/set-start-end-time");
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logEndTime {}", (Object)endTimeMillis);
        }
        this.validateExperimentKeyPresent();
        ExperimentTimeRequest request = this.getLogEndTimeRequest(endTimeMillis);
        this.getConnection().sendPostAsync(request, "/api/rest/v2/write/experiment/set-start-end-time");
    }

    @Override
    public void uploadAsset(@NonNull File asset, final @NonNull String fileName, final boolean overwrite, final long step, final long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("uploadAsset from file {}, name {}, override {}, step {}, epoch {}", new Object[]{asset.getName(), fileName, overwrite, step, epoch});
        }
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(asset, "/api/rest/v2/write/experiment/upload-asset", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("experimentKey", BaseExperiment.this.getExperimentKey());
                this.put("fileName", fileName);
                this.put("step", Long.toString(step));
                this.put("epoch", Long.toString(epoch));
                this.put("context", BaseExperiment.this.getContext());
                this.put("overwrite", Boolean.toString(overwrite));
            }
        }).toCompletableFuture().exceptionally(t -> {
            this.getLogger().error("failed to upload asset from file {} with name {}", new Object[]{asset, fileName, t});
            return null;
        });
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, step, epoch);
    }

    @Override
    public void logGitMetadata(CreateGitMetadata gitMetadata) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("gitMetadata {}", (Object)gitMetadata);
        }
        this.validateExperimentKeyPresent();
        this.getConnection().sendPostAsync(gitMetadata, "/api/rest/v2/write/experiment/git/metadata");
    }

    @Override
    public ExperimentMetadataRest getMetadata() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metadata for experiment {}", (Object)experimentKey);
        }
        return this.getForExperimentByKey("/api/rest/v2/experiment/metadata", ExperimentMetadataRest.class);
    }

    @Override
    public GitMetadataRest getGitMetadata() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get git metadata for experiment {}", (Object)experimentKey);
        }
        return this.getForExperimentByKey("/api/rest/v2/experiment/git/metadata", GitMetadataRest.class);
    }

    @Override
    public Optional<String> getHtml() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get html for experiment {}", (Object)experimentKey);
        }
        GetHtmlResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/html", GetHtmlResponse.class);
        return Optional.ofNullable(response.getHtml());
    }

    @Override
    public Optional<String> getOutput() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get output for experiment {}", (Object)experimentKey);
        }
        GetOutputResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/output", GetOutputResponse.class);
        return Optional.ofNullable(response.getOutput());
    }

    @Override
    public Optional<String> getGraph() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get graph for experiment {}", (Object)experimentKey);
        }
        GetGraphResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/graph", GetGraphResponse.class);
        return Optional.ofNullable(response.getGraph());
    }

    @Override
    public List<ValueMinMaxDto> getParameters() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get params for experiment {}", (Object)experimentKey);
        }
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/parameters", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<ValueMinMaxDto> getMetrics() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metrics summary for experiment {}", (Object)experimentKey);
        }
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/metrics/summary", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<ValueMinMaxDto> getLogOther() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get log other for experiment {}", (Object)experimentKey);
        }
        MinMaxResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/log-other", MinMaxResponse.class);
        return response.getValues();
    }

    @Override
    public List<String> getTags() {
        String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get tags for experiment {}", (Object)experimentKey);
        }
        TagsResponse response = this.getForExperimentByKey("/api/rest/v2/experiment/tags", TagsResponse.class);
        return response.getTags();
    }

    @Override
    public void end() {
        this.getLogger().info("Waiting for all uploads to complete. It can take up to {} seconds", (Object)ConfigUtils.getConnectionCloseTimeoutSec());
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                connection.waitAndClose(ConfigUtils.getConnectionCloseTimeoutSec(), TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.getLogger().error("failed to close connection", (Throwable)e);
            }
        }
    }

    @Override
    public List<ExperimentAssetLink> getAssetList(final @NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        final String experimentKey = this.validateAndGetExperimentKey();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get assets with type {} for experiment {}", (Object)type, (Object)experimentKey);
        }
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("experimentKey", experimentKey);
                this.put("type", type);
            }
        };
        ExperimentAssetListResponse response = this.getForExperiment("/api/rest/v2/experiment/asset/list", (Map<String, String>)params, ExperimentAssetListResponse.class);
        return response.getAssets();
    }

    private <T> T getForExperimentByKey(@NonNull String endpoint, Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return this.getForExperiment(endpoint, Collections.singletonMap("experimentKey", this.getExperimentKey()), clazz);
    }

    private <T> T getForExperiment(@NonNull String endpoint, @NonNull Map<String, String> params, Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return (T)this.getConnection().sendGet(endpoint, params).map(body -> JsonUtils.fromJson(body, clazz)).orElseThrow(() -> new IllegalArgumentException("Empty response received for experiment from " + endpoint));
    }

    private String getObjectValue(Object val) {
        return val.toString();
    }

    private void validateExperimentKeyPresent() {
        if (this.getExperimentKey() == null) {
            throw new IllegalStateException("Experiment key must be present!");
        }
    }

    private String validateAndGetExperimentKey() {
        this.validateExperimentKeyPresent();
        return this.getExperimentKey();
    }

    private MetricRest getLogMetricRequest(@NonNull String metricName, @NonNull Object metricValue, long step, long epoch) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        MetricRest request = new MetricRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setMetricName(metricName);
        request.setMetricValue(this.getObjectValue(metricValue));
        request.setStep(step);
        request.setEpoch(epoch);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private ParameterRest getLogParameterRequest(@NonNull String parameterName, @NonNull Object paramValue, long step) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        ParameterRest request = new ParameterRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setParameterName(parameterName);
        request.setParameterValue(this.getObjectValue(paramValue));
        request.setStep(step);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private HtmlRest getLogHtmlRequest(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        HtmlRest request = new HtmlRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setHtml(html);
        request.setOverride(override);
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private LogOtherRest getLogOtherRequest(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        LogOtherRest request = new LogOtherRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setKey(key);
        request.setValue(this.getObjectValue(value));
        request.setTimestamp(System.currentTimeMillis());
        return request;
    }

    private AddTagsToExperimentRest getTagRequest(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        AddTagsToExperimentRest request = new AddTagsToExperimentRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setAddedTags(Collections.singletonList(tag));
        return request;
    }

    private AddGraphRest getGraphRequest(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        AddGraphRest request = new AddGraphRest();
        request.setExperimentKey(this.getExperimentKey());
        request.setGraph(graph);
        return request;
    }

    private ExperimentTimeRequest getLogStartTimeRequest(long startTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setExperimentKey(this.getExperimentKey());
        request.setStartTimeMillis(startTimeMillis);
        return request;
    }

    private ExperimentTimeRequest getLogEndTimeRequest(long endTimeMillis) {
        ExperimentTimeRequest request = new ExperimentTimeRequest();
        request.setExperimentKey(this.getExperimentKey());
        request.setEndTimeMillis(endTimeMillis);
        return request;
    }
}

