/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.GetExperimentsResponse;
import ml.comet.experiment.model.GetProjectsResponse;
import ml.comet.experiment.model.GetWorkspacesResponse;
import ml.comet.experiment.model.RestProject;
import ml.comet.experiment.utils.ConfigUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CometApiImpl
implements CometApi {
    private final Connection connection;

    public CometApiImpl(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
        this.connection = ConnectionInitializer.initConnection(apiKey, baseUrl, maxAuthRetries, logger);
    }

    @Override
    public List<String> getAllWorkspaces() {
        GetWorkspacesResponse response = this.getObject("/api/rest/v2/workspaces", Collections.emptyMap(), GetWorkspacesResponse.class);
        return response.getWorkspaceNames();
    }

    @Override
    public List<RestProject> getAllProjects(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        Map<String, String> params = Collections.singletonMap("workspaceName", workspaceName);
        GetProjectsResponse response = this.getObject("/api/rest/v2/projects", params, GetProjectsResponse.class);
        return response.getProjects();
    }

    @Override
    public List<ExperimentMetadataRest> getAllExperiments(@NonNull String projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        Map<String, String> params = Collections.singletonMap("projectId", projectId);
        GetExperimentsResponse response = this.getObject("/api/rest/v2/experiments", params, GetExperimentsResponse.class);
        return response.getExperiments();
    }

    private <T> T getObject(@NonNull String endpoint, @NonNull Map<String, String> params, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)this.connection.sendGet(endpoint, params).map(body -> JsonUtils.fromJson(body, clazz)).orElseThrow(() -> new IllegalArgumentException("Failed to parse endpoint response " + endpoint));
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilder();
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public static final class CometApiBuilder {
        private String apiKey = ConfigUtils.getApiKey().orElse(null);
        private String baseUrl = ConfigUtils.getBaseUrlOrDefault();
        private int maxAuthRetries = ConfigUtils.getMaxAuthRetriesOrDefault();

        CometApiBuilder() {
        }

        public CometApiBuilder withConfig(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            Config config = ConfigUtils.getConfigFromFile(overrideConfig);
            this.apiKey = config.getString("apiKey");
            this.baseUrl = config.getString("url");
            this.maxAuthRetries = config.getInt("maxAuthRetries");
            return this;
        }

        public CometApiBuilder withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public CometApiImpl build() {
            return new CometApiImpl(this.apiKey, this.baseUrl, this.maxAuthRetries);
        }
    }
}

