/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import lombok.NonNull;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.http.ConnectionUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.slf4j.Logger;

public final class Connection
implements Closeable {
    public static final int REQUEST_TIMEOUT_MS = 60000;
    public static final int CONNECTION_SHUTDOWN_TIMEOUT_MS = 5000;
    public static final String COMET_SDK_API_HEADER = "Comet-Sdk-Api";
    private static final String RESPONSE_NO_BODY = "NO BODY";
    private final String cometBaseUrl;
    private final String apiKey;
    private final Logger logger;
    private final int maxAuthRetries;
    private final AsyncHttpClient asyncHttpClient;
    private final AtomicInteger requestsInventory;

    public Connection(@NonNull String cometBaseUrl, @NonNull String apiKey, int maxAuthRetries, @NonNull Logger logger) {
        if (cometBaseUrl == null) {
            throw new NullPointerException("cometBaseUrl is marked non-null but is null");
        }
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.cometBaseUrl = cometBaseUrl;
        this.apiKey = apiKey;
        this.logger = logger;
        this.maxAuthRetries = maxAuthRetries;
        this.requestsInventory = new AtomicInteger();
        DefaultAsyncHttpClientConfig conf = new DefaultAsyncHttpClientConfig.Builder().setRequestTimeout(60000).setShutdownTimeout(5000).build();
        this.asyncHttpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)conf);
    }

    public Optional<String> sendGet(@NonNull String endpoint, @NonNull Map<String, String> params) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.executeRequestWithAuth(ConnectionUtils.createGetRequest(this.buildCometUrl(endpoint), params), false);
    }

    public Optional<String> sendPost(@NonNull String json, @NonNull String endpoint, boolean throwOnFailure) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        String url = this.buildCometUrl(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending JSON {} to {}", (Object)json, (Object)url);
        }
        return this.executeRequestWithAuth(ConnectionUtils.createPostJsonRequest(json, url), throwOnFailure);
    }

    public void sendPostAsync(@NonNull Object payload, @NonNull String endpoint) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        CompletionStage future = this.sendPostAsync(JsonUtils.toJson(payload), endpoint).toCompletableFuture().exceptionally(t -> {
            this.logger.error("failed to execute asynchronous request to endpoint {} with payload {}", new Object[]{endpoint, payload, t});
            return null;
        });
        if (this.logger.isDebugEnabled()) {
            ((CompletableFuture)future).thenApply(this.getDebugLogResponse(endpoint));
        }
    }

    public ListenableFuture<Response> sendPostAsync(@NonNull String json, @NonNull String endpoint) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return this.executeRequestWithAuthAsync(ConnectionUtils.createPostJsonRequest(json, this.buildCometUrl(endpoint)));
    }

    public ListenableFuture<Response> sendPostAsync(@NonNull File file, @NonNull String endpoint, @NonNull Map<String, String> params) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.executeRequestWithAuthAsync(ConnectionUtils.createPostFileRequest(file, this.buildCometUrl(endpoint), params));
    }

    public ListenableFuture<Response> sendPostAsync(byte[] bytes, @NonNull String endpoint, @NonNull Map<String, String> params) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = this.buildCometUrl(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending POST bytearray with length {} to {}", (Object)bytes.length, (Object)url);
        }
        return this.executeRequestWithAuthAsync(ConnectionUtils.createPostByteArrayRequest(bytes, url, params));
    }

    @Override
    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    public void waitAndClose(long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        long nanosTimeout = unit.toNanos(timeout);
        long deadline = System.nanoTime() + nanosTimeout;
        while (this.requestsInventory.get() > 0) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            nanosTimeout = deadline - System.nanoTime();
            if (nanosTimeout <= 0L) {
                throw new TimeoutException(String.format("timeout exceeded while waiting for remaining requests to complete, remaining requests: %d", this.requestsInventory.get()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("waiting for {} request items to execute, elapsed {} seconds", (Object)this.requestsInventory.get(), (Object)TimeUnit.SECONDS.convert(nanosTimeout, TimeUnit.NANOSECONDS));
            }
            Thread.sleep(100L);
        }
        this.close();
    }

    ListenableFuture<Response> executeRequestWithAuthAsync(@NonNull Request request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.asyncHttpClient.isClosed()) {
            String msg = String.format("failed to execute request %s connection to the server already closed", request);
            return new ListenableFuture.CompletedFailure("asyncHttpClient already closed", (Throwable)new CometGeneralException(msg));
        }
        this.requestsInventory.incrementAndGet();
        request.getHeaders().add(COMET_SDK_API_HEADER, (Object)this.apiKey);
        String endpoint = request.getUrl();
        return this.asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionInventoryHandler(this.requestsInventory, this.logger, endpoint));
    }

    Optional<String> executeRequestWithAuth(@NonNull Request request, boolean throwOnFailure) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        request.getHeaders().add(COMET_SDK_API_HEADER, (Object)this.apiKey);
        String endpoint = request.getUrl();
        try {
            Response response = null;
            for (int i = 1; i < this.maxAuthRetries; ++i) {
                if (this.asyncHttpClient.isClosed()) {
                    this.logger.warn("failed to execute request {}, the connection already closed.", (Object)request);
                    if (throwOnFailure) {
                        throw new CometGeneralException("failed to execute request, the connection already closed.");
                    }
                    return Optional.empty();
                }
                response = (Response)this.asyncHttpClient.executeRequest(request).get();
                if (!ConnectionUtils.isResponseSuccessful(response.getStatusCode())) {
                    if (i < this.maxAuthRetries - 1) {
                        this.logger.debug("for endpoint {} response {}, retrying\n", (Object)endpoint, (Object)response.getStatusText());
                        Thread.sleep((long)(2 ^ i) * 1000L);
                        continue;
                    }
                    this.logger.error("for endpoint {} response {}, last retry failed\n", (Object)endpoint, (Object)response.getStatusText());
                    if (!throwOnFailure) continue;
                    String body = response.hasResponseBody() ? response.getResponseBody() : RESPONSE_NO_BODY;
                    throw new CometGeneralException("failed to call: " + endpoint + ", response status: " + response.getStatusCode() + ", body: " + body);
                }
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("for endpoint {} got response {}\n", (Object)endpoint, (Object)response.getResponseBody());
                break;
            }
            if (response == null || !response.hasResponseBody()) {
                return Optional.empty();
            }
            return Optional.of(response.getResponseBody());
        }
        catch (Throwable e) {
            this.logger.error("Failed to execute request: " + request, e);
            return Optional.empty();
        }
    }

    private Function<Response, Response> getDebugLogResponse(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return new ConnectionUtils.DebugLogResponse(this.logger, endpoint);
    }

    private String buildCometUrl(String endpoint) {
        return this.cometBaseUrl + endpoint;
    }

    public String getCometBaseUrl() {
        return this.cometBaseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxAuthRetries() {
        return this.maxAuthRetries;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }

    public AtomicInteger getRequestsInventory() {
        return this.requestsInventory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (this.getMaxAuthRetries() != other.getMaxAuthRetries()) {
            return false;
        }
        String this$cometBaseUrl = this.getCometBaseUrl();
        String other$cometBaseUrl = other.getCometBaseUrl();
        if (this$cometBaseUrl == null ? other$cometBaseUrl != null : !this$cometBaseUrl.equals(other$cometBaseUrl)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        AsyncHttpClient this$asyncHttpClient = this.getAsyncHttpClient();
        AsyncHttpClient other$asyncHttpClient = other.getAsyncHttpClient();
        if (this$asyncHttpClient == null ? other$asyncHttpClient != null : !this$asyncHttpClient.equals(other$asyncHttpClient)) {
            return false;
        }
        AtomicInteger this$requestsInventory = this.getRequestsInventory();
        AtomicInteger other$requestsInventory = other.getRequestsInventory();
        return !(this$requestsInventory == null ? other$requestsInventory != null : !this$requestsInventory.equals(other$requestsInventory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxAuthRetries();
        String $cometBaseUrl = this.getCometBaseUrl();
        result = result * 59 + ($cometBaseUrl == null ? 43 : $cometBaseUrl.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        AsyncHttpClient $asyncHttpClient = this.getAsyncHttpClient();
        result = result * 59 + ($asyncHttpClient == null ? 43 : $asyncHttpClient.hashCode());
        AtomicInteger $requestsInventory = this.getRequestsInventory();
        result = result * 59 + ($requestsInventory == null ? 43 : $requestsInventory.hashCode());
        return result;
    }

    public String toString() {
        return "Connection(cometBaseUrl=" + this.getCometBaseUrl() + ", apiKey=" + this.getApiKey() + ", logger=" + this.getLogger() + ", maxAuthRetries=" + this.getMaxAuthRetries() + ", asyncHttpClient=" + this.getAsyncHttpClient() + ", requestsInventory=" + this.getRequestsInventory() + ")";
    }

    static final class AsyncCompletionInventoryHandler
    extends AsyncCompletionHandler<Response> {
        AtomicInteger requestInventory;
        Logger logger;
        String endpoint;

        AsyncCompletionInventoryHandler(AtomicInteger inventory, Logger logger, String endpoint) {
            this.requestInventory = inventory;
            this.logger = logger;
            this.endpoint = endpoint;
        }

        public Response onCompleted(Response response) {
            this.decreaseInventory();
            return response;
        }

        public void onThrowable(Throwable t) {
            this.decreaseInventory();
            this.logger.error("failed to execute request to the endpoint {}", (Object)this.endpoint, (Object)t);
        }

        private void decreaseInventory() {
            this.requestInventory.decrementAndGet();
        }
    }
}

