/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.http;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.ByteArrayBodyGenerator;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.util.HttpConstants;
import org.slf4j.Logger;

public class ConnectionUtils {
    static final String FILE = "file";
    static final String FORM_MIME_TYPE = "multipart/form-data";
    static final String JSON_MIME_TYPE = "application/json";

    static Request createGetRequest(@NonNull String url, Map<String, String> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)ConnectionUtils.createRequestBuilder(HttpConstants.Methods.GET, params).setUrl(url)).build();
    }

    static Request createPostFileRequest(@NonNull File file, @NonNull String url, Map<String, String> params) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)((RequestBuilder)((RequestBuilder)ConnectionUtils.createRequestBuilder(HttpConstants.Methods.POST, params).setUrl(url)).setHeader((CharSequence)"Content-Type", FORM_MIME_TYPE)).addBodyPart((Part)new FilePart(FILE, file, FORM_MIME_TYPE))).build();
    }

    static Request createPostByteArrayRequest(byte[] bytes, @NonNull String url, Map<String, String> params) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)((RequestBuilder)((RequestBuilder)ConnectionUtils.createRequestBuilder(HttpConstants.Methods.POST, params).setUrl(url)).setHeader((CharSequence)"Content-Type", FORM_MIME_TYPE)).addBodyPart((Part)new ByteArrayPart(FILE, bytes, FORM_MIME_TYPE))).build();
    }

    static Request createPostJsonRequest(@NonNull String body, @NonNull String url) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder().setUrl(url)).setHeader((CharSequence)"Content-Type", JSON_MIME_TYPE)).setBody((BodyGenerator)new ByteArrayBodyGenerator(body.getBytes()))).setMethod(HttpConstants.Methods.POST)).build();
    }

    static boolean isResponseSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    static RequestBuilder createRequestBuilder(@NonNull String httpMethod, Map<String, String> params) {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        RequestBuilder builder = new RequestBuilder(httpMethod);
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((RequestBuilder)builder).addQueryParam(arg_0, arg_1));
        }
        return builder;
    }

    public static final class DebugLogResponse
    implements Function<Response, Response> {
        private final Logger logger;
        private final String endpoint;

        @Override
        public Response apply(Response response) {
            if (ConnectionUtils.isResponseSuccessful(response.getStatusCode())) {
                this.logger.debug("for endpoint {} response {}\n", (Object)this.endpoint, (Object)response.getResponseBody());
            } else {
                this.logger.error("for endpoint {} response {}\n", (Object)this.endpoint, (Object)response.getStatusText());
            }
            return response;
        }

        public DebugLogResponse(Logger logger, String endpoint) {
            this.logger = logger;
            this.endpoint = endpoint;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugLogResponse)) {
                return false;
            }
            DebugLogResponse other = (DebugLogResponse)o;
            Logger this$logger = this.getLogger();
            Logger other$logger = other.getLogger();
            if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
                return false;
            }
            String this$endpoint = this.getEndpoint();
            String other$endpoint = other.getEndpoint();
            return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Logger $logger = this.getLogger();
            result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
            String $endpoint = this.getEndpoint();
            result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
            return result;
        }

        public String toString() {
            return "ConnectionUtils.DebugLogResponse(logger=" + this.getLogger() + ", endpoint=" + this.getEndpoint() + ")";
        }
    }
}

