/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.NonNull;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.BaseExperiment;
import ml.comet.experiment.impl.asset.Asset;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.asset.RemoteAsset;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.AssetUtils;
import ml.comet.experiment.impl.utils.DataUtils;
import ml.comet.experiment.model.GitMetadata;
import ml.comet.experiment.model.HtmlRest;
import ml.comet.experiment.model.LogDataResponse;
import ml.comet.experiment.model.LogOtherRest;
import ml.comet.experiment.model.MetricRest;
import ml.comet.experiment.model.OutputUpdate;
import ml.comet.experiment.model.ParameterRest;
import org.slf4j.Logger;

abstract class BaseExperimentAsync
extends BaseExperiment {
    ExperimentContext baseContext;
    final CompositeDisposable disposables = new CompositeDisposable();

    BaseExperimentAsync(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, String experimentKey, @NonNull Duration cleaningTimeout, String projectName, String workspaceName) {
        super(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, projectName, workspaceName);
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (cleaningTimeout == null) {
            throw new NullPointerException("cleaningTimeout is marked non-null but is null");
        }
        this.baseContext = ExperimentContext.empty();
    }

    @Override
    public void end() {
        if (!this.alive) {
            return;
        }
        super.end();
        if (this.disposables.size() > 0) {
            this.getLogger().warn("{} calls still has not been processed, disposing", (Object)this.disposables.size());
        }
        this.disposables.dispose();
    }

    void updateContext(ExperimentContext context) {
        this.baseContext.mergeFrom(context);
    }

    void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logMetricAsync {} = {}, context: {}", new Object[]{metricName, metricValue, context});
        }
        MetricRest metricRequest = DataUtils.createLogMetricRequest(metricName, metricValue, this.baseContext);
        this.sendAsynchronously(this.getRestApiClient()::logMetric, metricRequest, onComplete);
    }

    void logParameter(@NonNull String parameterName, @NonNull Object paramValue, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logParameterAsync {} = {}, context: {}", new Object[]{parameterName, paramValue, context});
        }
        ParameterRest paramRequest = DataUtils.createLogParamRequest(parameterName, paramValue, this.baseContext);
        this.sendAsynchronously(this.getRestApiClient()::logParameter, paramRequest, onComplete);
    }

    void logHtml(@NonNull String html, boolean override, Optional<Action> onComplete) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logHtmlAsync {}, override: {}", (Object)html, (Object)override);
        }
        HtmlRest htmlRequest = DataUtils.createLogHtmlRequest(html, override);
        this.sendAsynchronously(this.getRestApiClient()::logHtml, htmlRequest, onComplete);
    }

    void logOther(@NonNull String key, @NonNull Object value, Optional<Action> onComplete) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOtherAsync {} {}", (Object)key, value);
        }
        LogOtherRest request = DataUtils.createLogOtherRequest(key, value);
        this.sendAsynchronously(this.getRestApiClient()::logOther, request, onComplete);
    }

    public void addTag(@NonNull String tag, Optional<Action> onComplete) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addTagAsync {}", (Object)tag);
        }
        this.sendAsynchronously(this.getRestApiClient()::addTag, DataUtils.createTagRequest(tag), onComplete);
    }

    void logGraph(@NonNull String graph, Optional<Action> onComplete) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGraphAsync {}", (Object)graph);
        }
        this.sendAsynchronously(this.getRestApiClient()::logGraph, DataUtils.createGraphRequest(graph), onComplete);
    }

    void logStartTime(long startTimeMillis, Optional<Action> onComplete) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logStartTimeAsync {}", (Object)startTimeMillis);
        }
        this.sendAsynchronously(this.getRestApiClient()::logStartEndTime, DataUtils.createLogStartTimeRequest(startTimeMillis), onComplete);
    }

    void logEndTime(long endTimeMillis, Optional<Action> onComplete) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logEndTimeAsync {}", (Object)endTimeMillis);
        }
        this.sendAsynchronously(this.getRestApiClient()::logStartEndTime, DataUtils.createLogEndTimeRequest(endTimeMillis), onComplete);
    }

    void logGitMetadataAsync(@NonNull GitMetadata gitMetadata, Optional<Action> onComplete) {
        if (gitMetadata == null) {
            throw new NullPointerException("gitMetadata is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGitMetadata {}", (Object)gitMetadata);
        }
        this.sendAsynchronously(this.getRestApiClient()::logGitMetadata, gitMetadata, onComplete);
    }

    void logLine(String line, long offset, boolean stderr, String context, Optional<Action> onComplete) {
        OutputUpdate request = DataUtils.createLogLineRequest(line, offset, stderr, context);
        Single single = this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey -> this.getRestApiClient().logOutputLine(request, (String)experimentKey));
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.subscribe();
    }

    void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, boolean prefixWithFolderName, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (!folder.isDirectory()) {
            this.getLogger().error(LogMessages.getString("LOG_ASSET_FOLDER_EMPTY", folder));
            return;
        }
        this.updateContext(context);
        ExperimentContext assetContext = new ExperimentContext(this.baseContext);
        AtomicInteger count = new AtomicInteger();
        try {
            Stream<Asset> assets = AssetUtils.walkFolderAssets(folder, logFilePath, recursive, prefixWithFolderName).peek(asset -> {
                asset.setExperimentContext(assetContext);
                asset.setType(AssetType.ASSET_TYPE_ASSET);
                count.incrementAndGet();
            });
            Observable observable = Observable.fromStream(assets).flatMap(asset -> Observable.fromSingle(this.sendAssetAsync(this.getRestApiClient()::logAsset, asset)), true);
            if (onComplete.isPresent()) {
                observable = observable.doFinally(onComplete.get());
            }
            observable.ignoreElements().subscribe(() -> this.getLogger().info(LogMessages.getString("ASSETS_FOLDER_UPLOAD_COMPLETED", folder, count.get())), throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_LOG_SOME_ASSET_FROM_FOLDER", folder), throwable), (DisposableContainer)this.disposables);
        }
        catch (Throwable t) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_LOG_ASSET_FOLDER", folder), t);
        }
    }

    void uploadAsset(@NonNull File file, @NonNull String fileName, boolean overwrite, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        Asset asset = new Asset();
        asset.setFile(file);
        asset.setFileName(fileName);
        asset.setOverwrite(overwrite);
        asset.setType(AssetType.ASSET_TYPE_ASSET);
        this.logAsset(asset, onComplete);
    }

    void logRemoteAsset(@NonNull URI uri, Optional<String> fileName, boolean overwrite, Optional<Map<String, Object>> metadata, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        RemoteAsset asset = AssetUtils.createRemoteAsset(uri, fileName, overwrite, metadata);
        asset.setExperimentContext(this.baseContext);
        asset.setType(AssetType.ASSET_TYPE_ASSET);
        if (Objects.equals(asset.getFileName(), "remote")) {
            this.getLogger().info(LogMessages.getString("LOG_REMOTE_ASSET_URI_FILE_NAME_TO_DEFAULT", uri, "remote"));
        }
        this.logAsset(this.getRestApiClient()::logRemoteAsset, asset, onComplete);
    }

    void logCode(@NonNull String code, @NonNull String fileName, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        Asset asset = new Asset();
        asset.setFileLikeData(code.getBytes(StandardCharsets.UTF_8));
        asset.setFileName(fileName);
        asset.setType(AssetType.ASSET_TYPE_SOURCE_CODE);
        this.logAsset(asset, onComplete);
    }

    void logCode(@NonNull File file, @NonNull ExperimentContext context, Optional<Action> onComplete) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.updateContext(context);
        Asset asset = new Asset();
        asset.setFile(file);
        asset.setFileName(file.getName());
        asset.setType(AssetType.ASSET_TYPE_SOURCE_CODE);
        this.logAsset(asset, onComplete);
    }

    void logAsset(@NonNull Asset asset, Optional<Action> onComplete) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        asset.setExperimentContext(this.baseContext);
        this.logAsset(this.getRestApiClient()::logAsset, asset, onComplete);
    }

    private <T extends Asset> void logAsset(BiFunction<T, String, Single<LogDataResponse>> func, @NonNull T asset, Optional<Action> onComplete) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        Single single = this.sendAssetAsync(func, asset);
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.subscribe(logDataResponse -> {}, throwable -> {}, (DisposableContainer)this.disposables);
    }

    private <T extends Asset> Single<LogDataResponse> sendAssetAsync(BiFunction<T, String, Single<LogDataResponse>> func, @NonNull T asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        return this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey1 -> (Single)func.apply((Object)asset, experimentKey1)).doOnSuccess(logDataResponse -> AsyncDataResponseLogger.checkAndLog(logDataResponse, this.getLogger(), asset)).doOnError(throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_SEND_LOG_ASSET_REQUEST", asset), throwable));
    }

    private <T> void sendAsynchronously(BiFunction<T, String, Single<LogDataResponse>> func, T request, Optional<Action> onComplete) {
        Single single = this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey -> (Single)func.apply(request, experimentKey));
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.observeOn(Schedulers.single()).subscribe(logDataResponse -> AsyncDataResponseLogger.checkAndLog(logDataResponse, this.getLogger(), request), throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_SEND_LOG_REQUEST", request), throwable), (DisposableContainer)this.disposables);
    }

    static final class AsyncDataResponseLogger {
        AsyncDataResponseLogger() {
        }

        static void checkAndLog(LogDataResponse logDataResponse, Logger logger, Object request) {
            if (logDataResponse.hasFailed()) {
                logger.error("failed to log {}, reason: {}", request, (Object)logDataResponse.getMsg());
            } else if (logger.isDebugEnabled()) {
                logger.debug("successful response {} received for request {}", (Object)logDataResponse, request);
            }
        }
    }
}

