/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import ml.comet.experiment.artifact.AssetOverwriteStrategy;
import org.apache.commons.io.file.PathUtils;

public final class FileUtils {
    public static Stream<Path> listFiles(File folder, boolean recursive) throws IOException {
        ArrayList res;
        if (recursive) {
            try (Stream<Path> files = Files.walk(folder.toPath(), new FileVisitOption[0]);){
                res = files.collect(ArrayList::new, (paths, path) -> {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        paths.add(path);
                    }
                }, ArrayList::addAll);
            }
        }
        res = new ArrayList();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder.toPath());){
            files.forEach(path -> {
                if (!path.toFile().isDirectory()) {
                    res.add(path);
                }
            });
        }
        return res.stream().sorted(Comparator.naturalOrder());
    }

    public static Optional<Path> resolveAssetPath(@NonNull Path dir, @NonNull Path file, @NonNull AssetOverwriteStrategy overwriteStrategy) throws FileAlreadyExistsException, IOException {
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (overwriteStrategy == null) {
            throw new NullPointerException("overwriteStrategy is marked non-null but is null");
        }
        Path assetPath = FileUtils.assetFilePath(dir, file);
        if (Files.isRegularFile(assetPath, new LinkOption[0])) {
            switch (overwriteStrategy) {
                case PRESERVE: {
                    return Optional.empty();
                }
                case OVERWRITE: {
                    Files.delete(assetPath);
                    return Optional.of(assetPath);
                }
                case FAIL_IF_DIFFERENT: {
                    throw new FileAlreadyExistsException(assetPath.toString());
                }
            }
        }
        Files.createDirectories(assetPath.getParent(), new FileAttribute[0]);
        return Optional.of(assetPath);
    }

    public static boolean fileContentsEquals(@NonNull Path assetFile, @NonNull Path otherPath) throws IOException {
        if (assetFile == null) {
            throw new NullPointerException("assetFile is marked non-null but is null");
        }
        if (otherPath == null) {
            throw new NullPointerException("otherPath is marked non-null but is null");
        }
        return PathUtils.fileContentEquals((Path)assetFile, (Path)otherPath);
    }

    public static Path assetFilePath(@NonNull Path assetDir, @NonNull Path assetFile) {
        if (assetDir == null) {
            throw new NullPointerException("assetDir is marked non-null but is null");
        }
        if (assetFile == null) {
            throw new NullPointerException("assetFile is marked non-null but is null");
        }
        return assetDir.resolve(assetFile);
    }

    static String resolveAssetFileName(File folder, Path path, boolean logFilePath, boolean prefixWithFolderName) {
        if (logFilePath) {
            Path filePath = folder.toPath().relativize(path);
            if (prefixWithFolderName) {
                filePath = folder.toPath().getFileName().resolve(filePath);
            }
            return filePath.toString();
        }
        return path.getFileName().toString();
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

