/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.NonNull;
import ml.comet.experiment.artifact.Artifact;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.ArtifactException;
import ml.comet.experiment.artifact.GetArtifactOptions;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.asset.Asset;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.ArtifactImpl;
import ml.comet.experiment.impl.BaseExperiment;
import ml.comet.experiment.impl.LoggedArtifactImpl;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.asset.RemoteAssetImpl;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.ArtifactEntry;
import ml.comet.experiment.impl.rest.ArtifactVersionState;
import ml.comet.experiment.impl.rest.HtmlRest;
import ml.comet.experiment.impl.rest.LogOtherRest;
import ml.comet.experiment.impl.rest.MetricRest;
import ml.comet.experiment.impl.rest.OutputUpdate;
import ml.comet.experiment.impl.rest.ParameterRest;
import ml.comet.experiment.impl.rest.RestApiResponse;
import ml.comet.experiment.impl.utils.AssetUtils;
import ml.comet.experiment.impl.utils.DataModelUtils;
import ml.comet.experiment.model.GitMetaData;
import org.slf4j.Logger;

abstract class BaseExperimentAsync
extends BaseExperiment {
    ExperimentContext baseContext;
    final CompositeDisposable disposables = new CompositeDisposable();

    BaseExperimentAsync(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, String experimentKey, @NonNull Duration cleaningTimeout, String projectName, String workspaceName) {
        super(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, projectName, workspaceName);
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (cleaningTimeout == null) {
            throw new NullPointerException("cleaningTimeout is marked non-null but is null");
        }
        this.baseContext = ExperimentContext.empty();
    }

    @Override
    public void end() {
        if (!this.alive) {
            return;
        }
        super.end();
        if (this.disposables.size() > 0) {
            this.getLogger().warn("{} calls still has not been processed, disposing", (Object)this.disposables.size());
        }
        this.disposables.dispose();
    }

    void updateContext(ExperimentContext context) {
        this.baseContext.mergeFrom(context);
    }

    void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.updateContext(context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logMetricAsync {} = {}, context: {}", new Object[]{metricName, metricValue, context});
        }
        MetricRest metricRequest = DataModelUtils.createLogMetricRequest(metricName, metricValue, this.baseContext);
        this.sendAsynchronously(this.getRestApiClient()::logMetric, metricRequest, onComplete);
    }

    void logParameter(@NonNull String parameterName, @NonNull Object paramValue, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.updateContext(context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logParameterAsync {} = {}, context: {}", new Object[]{parameterName, paramValue, context});
        }
        ParameterRest paramRequest = DataModelUtils.createLogParamRequest(parameterName, paramValue, this.baseContext);
        this.sendAsynchronously(this.getRestApiClient()::logParameter, paramRequest, onComplete);
    }

    void logHtml(@NonNull String html, boolean override, @NonNull Optional<Action> onComplete) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logHtmlAsync {}, override: {}", (Object)html, (Object)override);
        }
        HtmlRest htmlRequest = DataModelUtils.createLogHtmlRequest(html, override);
        this.sendAsynchronously(this.getRestApiClient()::logHtml, htmlRequest, onComplete);
    }

    void logOther(@NonNull String key, @NonNull Object value, @NonNull Optional<Action> onComplete) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOtherAsync {} {}", (Object)key, value);
        }
        LogOtherRest request = DataModelUtils.createLogOtherRequest(key, value);
        this.sendAsynchronously(this.getRestApiClient()::logOther, request, onComplete);
    }

    public void addTag(@NonNull String tag, @NonNull Optional<Action> onComplete) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addTagAsync {}", (Object)tag);
        }
        this.sendAsynchronously(this.getRestApiClient()::addTag, DataModelUtils.createTagRequest(tag), onComplete);
    }

    void logGraph(@NonNull String graph, @NonNull Optional<Action> onComplete) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGraphAsync {}", (Object)graph);
        }
        this.sendAsynchronously(this.getRestApiClient()::logGraph, DataModelUtils.createGraphRequest(graph), onComplete);
    }

    void logStartTime(long startTimeMillis, @NonNull Optional<Action> onComplete) {
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logStartTimeAsync {}", (Object)startTimeMillis);
        }
        this.sendAsynchronously(this.getRestApiClient()::logStartEndTime, DataModelUtils.createLogStartTimeRequest(startTimeMillis), onComplete);
    }

    void logEndTime(long endTimeMillis, @NonNull Optional<Action> onComplete) {
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logEndTimeAsync {}", (Object)endTimeMillis);
        }
        this.sendAsynchronously(this.getRestApiClient()::logStartEndTime, DataModelUtils.createLogEndTimeRequest(endTimeMillis), onComplete);
    }

    void logGitMetadataAsync(@NonNull GitMetaData gitMetaData, @NonNull Optional<Action> onComplete) {
        if (gitMetaData == null) {
            throw new NullPointerException("gitMetaData is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGitMetadata {}", (Object)gitMetaData);
        }
        this.sendAsynchronously(this.getRestApiClient()::logGitMetadata, DataModelUtils.createGitMetadataRequest(gitMetaData), onComplete);
    }

    void logLine(String line, long offset, boolean stderr, String context, @NonNull Optional<Action> onComplete) {
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        if (!this.alive) {
            return;
        }
        OutputUpdate request = DataModelUtils.createLogLineRequest(line, offset, stderr, context);
        Single single = this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey -> this.getRestApiClient().logOutputLine(request, (String)experimentKey));
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.subscribe();
    }

    void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, boolean prefixWithFolderName, @NonNull Optional<String> assetType, @NonNull Optional<String> groupingName, @NonNull Optional<Map<String, Object>> metadata, @NonNull ExperimentContext context, @NonNull Optional<Action> onCompleteAction) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (assetType == null) {
            throw new NullPointerException("assetType is marked non-null but is null");
        }
        if (groupingName == null) {
            throw new NullPointerException("groupingName is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onCompleteAction == null) {
            throw new NullPointerException("onCompleteAction is marked non-null but is null");
        }
        if (!folder.isDirectory()) {
            this.getLogger().warn(LogMessages.getString("LOG_ASSET_FOLDER_EMPTY", folder));
            return;
        }
        this.updateContext(context);
        ExperimentContext assetContext = new ExperimentContext(this.baseContext);
        AtomicInteger successfullyLoggedCount = new AtomicInteger();
        try {
            Stream<AssetImpl> assets = AssetUtils.walkFolderAssets(folder, logFilePath, recursive, prefixWithFolderName, metadata, assetType, groupingName).peek(asset -> asset.setContext(assetContext));
            Observable responseObservable = Observable.fromStream(assets).flatMap(asset -> Observable.fromSingle((SingleSource)this.sendAssetAsync(this.getRestApiClient()::logAsset, asset).doOnSuccess(apiResponse -> {
                if (!apiResponse.hasFailed()) {
                    successfullyLoggedCount.incrementAndGet();
                }
            })), true);
            if (onCompleteAction.isPresent()) {
                responseObservable = responseObservable.doFinally(onCompleteAction.get());
            }
            responseObservable.ignoreElements().subscribe(() -> this.getLogger().info(LogMessages.getString("ASSETS_FOLDER_UPLOAD_COMPLETED", folder, successfullyLoggedCount.get())), throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_LOG_SOME_ASSET_FROM_FOLDER", folder), throwable), (DisposableContainer)this.disposables);
        }
        catch (Throwable t) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_LOG_ASSET_FOLDER", folder), t);
        }
    }

    void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, boolean prefixWithFolderName, @NonNull ExperimentContext context, @NonNull Optional<Action> onCompleteAction) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onCompleteAction == null) {
            throw new NullPointerException("onCompleteAction is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, recursive, prefixWithFolderName, Optional.of(AssetType.ASSET.type()), Optional.empty(), Optional.empty(), context, onCompleteAction);
    }

    void logRemoteAsset(@NonNull URI uri, Optional<String> logicalPath, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.updateContext(context);
        RemoteAssetImpl asset = AssetUtils.createRemoteAsset(uri, logicalPath, overwrite, metadata, Optional.empty());
        this.logAssetAsync(this.getRestApiClient()::logRemoteAsset, asset, onComplete);
        if (Objects.equals(asset.getLogicalPath(), "remote")) {
            this.getLogger().warn(LogMessages.getString("LOG_REMOTE_ASSET_URI_FILE_NAME_TO_DEFAULT", uri, "remote"));
        }
    }

    CompletableFuture<LoggedArtifact> logArtifact(@NonNull Artifact artifact, @NonNull Optional<Action> onComplete) throws ArtifactException {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        ArtifactEntry entry = super.upsertArtifact(artifact);
        LoggedArtifactImpl loggedArtifact = (LoggedArtifactImpl)this.getArtifactVersionDetail(GetArtifactOptions.Op().artifactId(entry.getArtifactId()).versionId(entry.getArtifactVersionId()).build());
        ArtifactImpl artifactImpl = (ArtifactImpl)artifact;
        if (artifactImpl.getAssets().size() == 0) {
            this.getLogger().warn(LogMessages.getString("ARTIFACT_LOGGED_WITHOUT_ASSETS", artifactImpl.getName()));
            return CompletableFuture.completedFuture(loggedArtifact);
        }
        this.getLogger().info(LogMessages.getString("ARTIFACT_UPLOAD_STARTED", loggedArtifact.getFullName(), artifactImpl.getAssets().size()));
        CompletableFuture<LoggedArtifact> future = new CompletableFuture<LoggedArtifact>();
        String artifactVersionId = entry.getArtifactVersionId();
        Stream<ArtifactAsset> assets = artifactImpl.getAssets().stream().peek(asset -> ((ArtifactAssetImpl)asset).setArtifactVersionId(artifactVersionId));
        AtomicInteger successfullySentCount = new AtomicInteger();
        Observable observable = Observable.fromStream(assets).flatMap(asset -> Observable.fromSingle((SingleSource)this.sendArtifactAssetAsync(asset).doOnSuccess(restApiResponse -> {
            if (!restApiResponse.hasFailed()) {
                successfullySentCount.incrementAndGet();
            }
        })), true);
        if (onComplete.isPresent()) {
            observable = observable.doFinally(onComplete.get());
        }
        observable.ignoreElements().subscribe(() -> {
            this.getLogger().info(LogMessages.getString("ARTIFACT_UPLOAD_COMPLETED", loggedArtifact.getFullName(), successfullySentCount.get()));
            this.updateArtifactVersionState(loggedArtifact, ArtifactVersionState.CLOSED, future);
            if (!future.isCompletedExceptionally()) {
                future.complete(loggedArtifact);
            }
        }, throwable -> {
            this.getLogger().error(LogMessages.getString("FAILED_TO_UPLOAD_SOME_ARTIFACT_ASSET", loggedArtifact.getFullName()), throwable);
            this.updateArtifactVersionState(loggedArtifact, ArtifactVersionState.ERROR, future);
            if (!future.isCompletedExceptionally()) {
                future.obtrudeException((Throwable)throwable);
            }
        }, (DisposableContainer)this.disposables);
        return future;
    }

    void updateArtifactVersionState(@NonNull LoggedArtifact loggedArtifact, @NonNull ArtifactVersionState state, CompletableFuture<LoggedArtifact> future) {
        if (loggedArtifact == null) {
            throw new NullPointerException("loggedArtifact is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        try {
            super.updateArtifactVersionState(loggedArtifact.getVersionId(), state);
        }
        catch (Throwable t) {
            this.getLogger().error(LogMessages.getString("FAILED_TO_FINALIZE_ARTIFACT_VERSION", loggedArtifact.getFullName()), t);
            future.completeExceptionally(t);
        }
    }

    void logAssetDataAsync(byte[] data, @NonNull String fileName, boolean overwrite, @NonNull Optional<String> assetType, @NonNull Optional<String> groupingName, @NonNull Optional<Map<String, Object>> metadata, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (assetType == null) {
            throw new NullPointerException("assetType is marked non-null but is null");
        }
        if (groupingName == null) {
            throw new NullPointerException("groupingName is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.updateContext(context);
        AssetImpl asset = AssetUtils.createAssetFromData(data, fileName, overwrite, metadata, assetType);
        groupingName.ifPresent(asset::setGroupingName);
        this.logAssetAsync(asset, onComplete);
    }

    void logAssetFileAsync(@NonNull File file, @NonNull String fileName, boolean overwrite, @NonNull Optional<String> assetType, @NonNull Optional<String> groupingName, @NonNull Optional<Map<String, Object>> metadata, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (assetType == null) {
            throw new NullPointerException("assetType is marked non-null but is null");
        }
        if (groupingName == null) {
            throw new NullPointerException("groupingName is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.updateContext(context);
        AssetImpl asset = AssetUtils.createAssetFromFile(file, Optional.of(fileName), overwrite, metadata, assetType);
        groupingName.ifPresent(asset::setGroupingName);
        this.logAssetAsync(asset, onComplete);
    }

    void logAssetFileAsync(@NonNull File file, @NonNull String fileName, boolean overwrite, @NonNull ExperimentContext context, @NonNull Optional<Action> onComplete) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.logAssetFileAsync(file, fileName, overwrite, Optional.of(AssetType.ASSET.type()), Optional.empty(), Optional.empty(), context, onComplete);
    }

    private void logAssetAsync(@NonNull Asset asset, @NonNull Optional<Action> onComplete) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        this.logAssetAsync(this.getRestApiClient()::logAsset, asset, onComplete);
    }

    private <T extends Asset> void logAssetAsync(@NonNull BiFunction<T, String, Single<RestApiResponse>> func, @NonNull T asset, @NonNull Optional<Action> onComplete) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        ((AssetImpl)asset).setContext(this.baseContext);
        Single single = this.sendAssetAsync(func, asset);
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.subscribe(restApiResponse -> {}, throwable -> {}, (DisposableContainer)this.disposables);
    }

    private <T extends Asset> Single<RestApiResponse> sendAssetAsync(@NonNull BiFunction<T, String, Single<RestApiResponse>> func, @NonNull T asset) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        return this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey -> (Single)func.apply((Object)asset, experimentKey)).doOnSuccess(restApiResponse -> BaseExperimentAsync.checkAndLogAssetResponse(restApiResponse, this.getLogger(), asset)).doOnError(throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_SEND_LOG_ASSET_REQUEST", asset), throwable));
    }

    private <T extends ArtifactAsset> Single<RestApiResponse> sendArtifactAssetAsync(@NonNull T asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        Scheduler scheduler = Schedulers.io();
        Single single = asset.isRemote() ? this.validateAndGetExperimentKey().subscribeOn(scheduler).concatMap(experimentKey -> this.getRestApiClient().logRemoteAsset(asset, (String)experimentKey)) : this.validateAndGetExperimentKey().subscribeOn(scheduler).concatMap(experimentKey -> this.getRestApiClient().logAsset(asset, (String)experimentKey));
        return single.doOnSuccess(restApiResponse -> BaseExperimentAsync.checkAndLogAssetResponse(restApiResponse, this.getLogger(), asset)).doOnError(throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_SEND_LOG_ARTIFACT_ASSET_REQUEST", asset), throwable));
    }

    private <T> void sendAsynchronously(@NonNull BiFunction<T, String, Single<RestApiResponse>> func, @NonNull T request, @NonNull Optional<Action> onComplete) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (onComplete == null) {
            throw new NullPointerException("onComplete is marked non-null but is null");
        }
        Single single = this.validateAndGetExperimentKey().subscribeOn(Schedulers.io()).concatMap(experimentKey -> (Single)func.apply(request, experimentKey));
        if (onComplete.isPresent()) {
            single = single.doFinally(onComplete.get());
        }
        single.observeOn(Schedulers.single()).subscribe(restApiResponse -> BaseExperimentAsync.checkAndLogResponse(restApiResponse, this.getLogger(), request), throwable -> this.getLogger().error(LogMessages.getString("FAILED_TO_SEND_LOG_REQUEST", request), throwable), (DisposableContainer)this.disposables);
    }

    static void checkAndLogResponse(@NonNull RestApiResponse restApiResponse, @NonNull Logger logger, Object request) {
        if (restApiResponse == null) {
            throw new NullPointerException("restApiResponse is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (restApiResponse.hasFailed()) {
            logger.error("failed to log {}, reason: {}, sdk error code: {}", new Object[]{request, restApiResponse.getMsg(), restApiResponse.getSdkErrorCode()});
        } else if (logger.isDebugEnabled()) {
            logger.debug("successful response {} received for request {}", (Object)restApiResponse, request);
        }
    }

    static void checkAndLogAssetResponse(@NonNull RestApiResponse restApiResponse, @NonNull Logger logger, Asset asset) {
        if (restApiResponse == null) {
            throw new NullPointerException("restApiResponse is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (restApiResponse.hasFailed()) {
            logger.error("failed to log asset {}, reason: {}, sdk error code: {}", new Object[]{asset, restApiResponse.getMsg(), restApiResponse.getSdkErrorCode()});
        } else {
            logger.info("Successfully logged asset {}", (Object)asset);
        }
    }
}

