/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.exception.ConfigException;
import ml.comet.experiment.impl.config.ConfigItem;
import ml.comet.experiment.impl.config.EnvironmentConfig;

public final class CometConfig {
    private static final CometConfig instance = new CometConfig();
    public static final ConfigItem COMET_API_KEY;
    public static final ConfigItem COMET_PROJECT_NAME;
    public static final ConfigItem COMET_WORKSPACE_NAME;
    public static final ConfigItem COMET_BASE_URL;
    public static final ConfigItem COMET_MAX_AUTH_RETRIES;
    public static final ConfigItem COMET_TIMEOUT_CLEANING_SECONDS;
    private static final String ERR_MISSING_FORMAT = "No configuration parameter [%s] found! Please specify it in the environment variables or configuration file";
    Config defaultConfig;
    Config config;

    public static void applyConfigOverride(@NonNull File configFile) {
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        Config overrideConfig = ConfigFactory.parseFile((File)configFile).getConfig("comet");
        overrideConfig.withFallback((ConfigMergeable)CometConfig.instance.defaultConfig);
        CometConfig.instance.config = overrideConfig;
    }

    public static void applyConfigOverride(@NonNull URL configFileUrl) {
        if (configFileUrl == null) {
            throw new NullPointerException("configFileUrl is marked non-null but is null");
        }
        Config overrideConfig = ConfigFactory.parseURL((URL)configFileUrl).getConfig("comet");
        overrideConfig.withFallback((ConfigMergeable)CometConfig.instance.defaultConfig);
        CometConfig.instance.config = overrideConfig;
    }

    public static void clearConfigOverride() {
        assert (CometConfig.instance.defaultConfig != null);
        CometConfig.instance.config = CometConfig.instance.defaultConfig;
    }

    static void loadDefaultConfig() {
        try {
            CometConfig.instance.config = CometConfig.instance.defaultConfig = ConfigFactory.load().getConfig("comet");
        }
        catch (com.typesafe.config.ConfigException e) {
            e.printStackTrace();
        }
    }

    String getString(@NonNull ConfigItem item) throws ConfigException {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return instance.readValue(item).orElseThrow(() -> new ConfigException(String.format(ERR_MISSING_FORMAT, item)));
    }

    Optional<String> getOptionalString(@NonNull ConfigItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return instance.readValue(item);
    }

    int getInt(@NonNull ConfigItem item) throws ConfigException {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        try {
            return instance.readValue(item).map(Integer::parseInt).orElseThrow(() -> new ConfigException(String.format(ERR_MISSING_FORMAT, item)));
        }
        catch (NumberFormatException e) {
            throw new ConfigException("failed to parse integer parameter value for the config item: " + item, e);
        }
    }

    Duration getDuration(@NonNull ConfigItem item) throws ConfigException {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        try {
            int duration = instance.readValue(item).map(Integer::parseInt).orElseThrow(() -> new ConfigException(String.format(ERR_MISSING_FORMAT, item)));
            return Duration.of(duration, ChronoUnit.SECONDS);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("failed to parse integer parameter value for the config item: " + item, e);
        }
    }

    private Optional<String> readValue(@NonNull ConfigItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Optional<String> envVariable = EnvironmentConfig.getEnvVariable(item.getEnvironmentKey());
        if (envVariable.isPresent()) {
            return envVariable;
        }
        if (CometConfig.instance.config.hasPath(item.getConfigKey())) {
            return Optional.of(CometConfig.instance.config.getString(item.getConfigKey()));
        }
        return Optional.empty();
    }

    static {
        CometConfig.loadDefaultConfig();
        COMET_API_KEY = new ConfigItem("apiKey", "COMET_API_KEY", instance);
        COMET_PROJECT_NAME = new ConfigItem("project", "COMET_PROJECT_NAME", instance);
        COMET_WORKSPACE_NAME = new ConfigItem("workspace", "COMET_WORKSPACE_NAME", instance);
        COMET_BASE_URL = new ConfigItem("baseUrl", "COMET_BASE_URL", instance);
        COMET_MAX_AUTH_RETRIES = new ConfigItem("maxAuthRetries", "COMET_MAX_AUTH_RETRIES", instance);
        COMET_TIMEOUT_CLEANING_SECONDS = new ConfigItem("cleaningTimeoutSeconds", "COMET_TIMEOUT_CLEANING", instance);
    }
}

