/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.artifact.GetArtifactOptions;
import ml.comet.experiment.impl.asset.DownloadArtifactAssetOptions;
import ml.comet.experiment.impl.constants.QueryParamName;

public final class ArtifactUtils {
    public static Map<QueryParamName, String> versionDetailsParams(@NonNull GetArtifactOptions options, @NonNull String experimentKey) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        Map<QueryParamName, String> queryParams = ArtifactUtils.versionParams(options);
        queryParams.put(QueryParamName.CONSUMER_EXPERIMENT_KEY, options.getConsumerExperimentKey());
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.PROJECT, options.getProject());
        queryParams.put(QueryParamName.VERSION_OR_ALIAS, options.getVersionOrAlias());
        return queryParams;
    }

    public static Map<QueryParamName, String> versionFilesParams(@NonNull GetArtifactOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return ArtifactUtils.versionParams(options);
    }

    static Map<QueryParamName, String> versionParams(@NonNull GetArtifactOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.ALIAS, options.getAlias());
        queryParams.put(QueryParamName.ARTIFACT_ID, options.getArtifactId());
        queryParams.put(QueryParamName.ARTIFACT_NAME, options.getArtifactName());
        queryParams.put(QueryParamName.VERSION_ID, options.getVersionId());
        queryParams.put(QueryParamName.VERSION, options.getVersion());
        queryParams.put(QueryParamName.WORKSPACE, options.getWorkspace());
        return queryParams;
    }

    public static Map<QueryParamName, String> downloadAssetParams(@NonNull DownloadArtifactAssetOptions options, @NonNull String experimentKey) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.ASSET_ID, options.getAssetId());
        queryParams.put(QueryParamName.ARTIFACT_VERSION_ID, options.getArtifactVersionId());
        return queryParams;
    }

    public static String artifactFullName(String workspace, String name, String version) {
        return String.format("%s/%s:%s", workspace, name, version);
    }

    private ArtifactUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

