package dc.android.base.wrapper;

import android.app.Activity;
import dc.android.common.BridgeOpcode;
import dc.android.common.utils.KeepInstance;
import dc.android.common.utils.TaskUtils;

/**
 * @author senrsl
 * @ClassName: SplashWrapper
 * @Package: dc.android.base.wrapper
 * @CreateTime: 2019/4/24 5:01 PM
 */
public class SplashWrapper {

    private Activity activity;

    public SplashWrapper(Activity activity) {
        this.activity = activity;
    }

    public void checkKeep() {
        switch (KeepInstance.getInstance().getStatus()) {
            case BridgeOpcode.DEFAULT:
                splash();
                break;
            case BridgeOpcode.YES:
                break;
            default:
                break;
        }
    }


    protected void splash() {
        new TaskUtils().startWelcome(activity, BridgeOpcode.DEFAULT);
    }


}
