package dc.android.common.utils;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import dc.android.bridge.fragment.BaseFragment;

/**
 * @author senrsl
 * @ClassName: FragmentUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2019/1/25 4:11 PM
 */
public class FragmentUtils {

    public static void addFragment(@NonNull FragmentManager fragmentManager, int layout, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(layout, fragment);
        fragmentTransaction.commit();
    }

    public static void replaceFragment(@NonNull FragmentManager fragmentManager, int layout, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.replace(layout, fragment);
        fragmentTransaction.commit();
    }

    public static void removeFragment(@NonNull FragmentManager fragmentManager, @NonNull BaseFragment fragment) {
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.remove(fragment);
        fragmentTransaction.commit();
    }

}
