package dc.android.bridge.adapter;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import dc.android.base.listener.OnItemClickListener;
import dc.android.base.listener.OnItemLongClickLIstener;
import dc.android.bridge.annotation.RecyclerItemViewId;

/**
 * @author senrsl
 * @ClassName: PurposeRecyclerAdapter
 * @Package: dc.test.sample.dog.view.adapter
 * @CreateTime: 2018/11/20 11:22 AM
 */
public class PurposeRecyclerAdapter<T> extends RecyclerView.Adapter<PurposeRecyclerAdapter.PurposeViewHolder> {

    protected Context mContext;
    /**
     * 布局资源id
     */
    protected int mLayoutId;
    /**
     * 子类
     */
    private Class<? extends PurposeViewHolder> viewHolderClass;
    /**
     * 填充数据
     */
    protected List<T> mDatas = new ArrayList<>();

    private OnItemClickListener listenerClick;
    private OnItemLongClickLIstener listenerClickLong;

    /**
     * 这个构造配合下面set使用
     */
    public PurposeRecyclerAdapter() {
    }

    /**
     * 一般使用这个就够了
     *
     * @param viewHolderClass
     */
    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass) {
        setViewHolderClass(viewHolderClass);
    }

    /**
     * 去annotation
     *
     * @param viewHolderClass
     * @param layoutId
     */
    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass, int layoutId) {
        setViewHolderClass(viewHolderClass, layoutId);
    }

    /**
     * 当初始化时，如果集合内有值，可以使用这个
     *
     * @param viewHolderClass
     * @param Datas
     */
    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass, List<T> Datas) {
        setViewHolderClass(viewHolderClass);
        mDatas = Datas;
    }

    public void setViewHolderClass(Class<? extends PurposeViewHolder> viewHolderClass) {
        this.viewHolderClass = viewHolderClass;
        this.mLayoutId = viewHolderClass.getAnnotation(RecyclerItemViewId.class).value();
    }

    /**
     * 去annotation
     *
     * @param viewHolderClass
     * @param layoutId
     */
    public void setViewHolderClass(Class<? extends PurposeViewHolder> viewHolderClass, int layoutId) {
        this.viewHolderClass = viewHolderClass;
        this.mLayoutId = layoutId;
    }

    public void setDatas(List<T> mDatas) {
        this.mDatas = mDatas;
    }

    public OnItemClickListener getListenerClick() {
        return listenerClick;
    }

    public OnItemLongClickLIstener getListenerClickLong() {
        return listenerClickLong;
    }

    public void setListenerClick(OnItemClickListener listenerClick) {
        this.listenerClick = listenerClick;
    }

    public void setListenerClickLong(OnItemLongClickLIstener listenerClickLong) {
        this.listenerClickLong = listenerClickLong;
    }

    @Override
    public PurposeViewHolder onCreateViewHolder(final ViewGroup parent, int viewType) {
        PurposeViewHolder viewHolder = null;
        if (mContext == null)
            mContext = parent.getContext();

        try {
            View converView = LayoutInflater.from(parent.getContext()).inflate(mLayoutId, parent, false);
            viewHolder = viewHolderClass.getConstructor(View.class).newInstance(converView);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(PurposeViewHolder holder, int position) {
        holder.convert(mDatas.get(position), this, mContext, position);//这里更新数据
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }

    public void add(int positon, T data) {
        mDatas.add(positon, data);
        notifyItemInserted(positon);
        new Handler().postDelayed(() -> notifyDataSetChanged(), 500);

    }

    public void add(T data) {
        mDatas.add(data);
        notifyDataSetChanged();

    }

    public void add(List<T> data) {
        mDatas.clear();
        mDatas.addAll(data);
        notifyDataSetChanged();
    }

    public void remove(int position) {
        mDatas.remove(position);
        notifyItemRemoved(position);
        new Handler().postDelayed(() -> notifyDataSetChanged(), 500);
    }

    public void update(int position, T data) {
//        mDatas.remove(position);
//        mDatas.add(position == 0 ? position : position - 1, data);
        mDatas.set(position, data);
        notifyDataSetChanged();
    }

    public void update(List<T> listData) {
        this.mDatas = listData;
        notifyDataSetChanged();
    }

    public void addAll(List<T> datas) {
        mDatas.addAll(datas);
        notifyDataSetChanged();
    }

    public void clear() {
        mDatas.clear();
        notifyDataSetChanged();
    }

    public List<T> getItems() {
        return mDatas;
    }

    /**
     * holder 抽象类
     *
     * @param <T>
     */
    public abstract static class PurposeViewHolder<T> extends RecyclerView.ViewHolder {

        public PurposeViewHolder(View itemView) {
            super(itemView);
        }

        /**
         * 子类转换
         *
         * @param bean     bean类型
         * @param adapter  adapter对象
         * @param context  context对象
         * @param position 位置
         */
        public abstract void convert(T bean, PurposeRecyclerAdapter adapter, Context context, int position);
    }

}
