package dc.android.bridge.fragment;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import dc.android.bridge.adapter.wrapper.RecyclerWrapper;
import dc.android.common.BridgeOpcode;

/**
 * @author senrsl
 * @ClassName: BaseListWrapperFooterFragment
 * @Package: dc.android.bridge.fragment
 * @CreateTime: 2019/1/18 6:22 PM
 */
public class BaseListWrapperFooterFragment extends BaseListFragment implements RecyclerWrapper.OnLoadMoreListener {


    //方式二
    private LinearLayout layoutFooter;


    protected void initWrapperLayout(LinearLayout layoutFooter) {
        this.layoutFooter = layoutFooter;
    }


    //方式二，通过设置高度的方式显示
    protected void setHeight(int footerHeight) {
        setHeightFooter(footerHeight);
    }


    protected void setHeightFooter(int footerHeight) {
        if (footerHeight == BridgeOpcode.DEFAULT) return;
        ViewGroup.LayoutParams paramsFooter = layoutFooter.getLayoutParams();
        paramsFooter.height = footerHeight;
        layoutFooter.setLayoutParams(paramsFooter);
    }


    @Override
    public void onLoadMore() {

    }

    @Override
    public void onClickLoadMore() {

    }

    @Override
    public void onItemClick(View view, int position) {

    }

}
