/*
 * Decompiled with CFR 0.152.
 */
package dc.android.bridge.adapter;

import android.content.Context;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import dc.android.base.listener.OnItemClickListener;
import dc.android.base.listener.OnItemLongClickLIstener;
import dc.android.bridge.annotation.RecyclerItemViewId;
import java.util.ArrayList;
import java.util.List;

public class PurposeRecyclerAdapter<T>
extends RecyclerView.Adapter<PurposeViewHolder> {
    protected Context mContext;
    protected int mLayoutId;
    private Class<? extends PurposeViewHolder> viewHolderClass;
    protected List<T> mDatas = new ArrayList<T>();
    private OnItemClickListener listenerClick;
    private OnItemLongClickLIstener listenerClickLong;

    public PurposeRecyclerAdapter() {
    }

    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass) {
        this.setViewHolderClass(viewHolderClass);
    }

    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass, int layoutId) {
        this.setViewHolderClass(viewHolderClass, layoutId);
    }

    public PurposeRecyclerAdapter(Class<PurposeViewHolder> viewHolderClass, List<T> Datas) {
        this.setViewHolderClass(viewHolderClass);
        this.mDatas = Datas;
    }

    public void setViewHolderClass(Class<? extends PurposeViewHolder> viewHolderClass) {
        this.viewHolderClass = viewHolderClass;
        this.mLayoutId = viewHolderClass.getAnnotation(RecyclerItemViewId.class).value();
    }

    public void setViewHolderClass(Class<? extends PurposeViewHolder> viewHolderClass, int layoutId) {
        this.viewHolderClass = viewHolderClass;
        this.mLayoutId = layoutId;
    }

    public void setDatas(List<T> mDatas) {
        this.mDatas = mDatas;
    }

    public OnItemClickListener getListenerClick() {
        return this.listenerClick;
    }

    public OnItemLongClickLIstener getListenerClickLong() {
        return this.listenerClickLong;
    }

    public void setListenerClick(OnItemClickListener listenerClick) {
        this.listenerClick = listenerClick;
    }

    public void setListenerClickLong(OnItemLongClickLIstener listenerClickLong) {
        this.listenerClickLong = listenerClickLong;
    }

    public PurposeViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PurposeViewHolder viewHolder = null;
        if (this.mContext == null) {
            this.mContext = parent.getContext();
        }
        try {
            View converView = LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayoutId, parent, false);
            viewHolder = this.viewHolderClass.getConstructor(View.class).newInstance(converView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return viewHolder;
    }

    public void onBindViewHolder(PurposeViewHolder holder, int position) {
        holder.convert(this.mDatas.get(position), this, this.mContext, position);
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public void add(int positon, T data) {
        this.mDatas.add(positon, data);
        this.notifyItemInserted(positon);
        new Handler().postDelayed(() -> this.notifyDataSetChanged(), 500L);
    }

    public void add(T data) {
        this.mDatas.add(data);
        this.notifyDataSetChanged();
    }

    public void add(List<T> data) {
        this.mDatas.clear();
        this.mDatas.addAll(data);
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.mDatas.remove(position);
        this.notifyItemRemoved(position);
        new Handler().postDelayed(() -> this.notifyDataSetChanged(), 500L);
    }

    public void update(int position, T data) {
        this.mDatas.set(position, data);
        this.notifyDataSetChanged();
    }

    public void update(List<T> listData) {
        this.mDatas = listData;
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> datas) {
        this.mDatas.addAll(datas);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mDatas.clear();
        this.notifyDataSetChanged();
    }

    public List<T> getItems() {
        return this.mDatas;
    }

    public static abstract class PurposeViewHolder<T>
    extends RecyclerView.ViewHolder {
        public PurposeViewHolder(View itemView) {
            super(itemView);
        }

        public abstract void convert(T var1, PurposeRecyclerAdapter var2, Context var3, int var4);
    }
}

