package dc.android.bridge.adapter.wrapper;


import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

/**
 * 适用wrapper方式为recyclerView增加首尾
 * 渣代码
 *
 * @author senrsl
 * @ClassName: RecyclerWrapper
 * @Package: dc.android.common.wrapper
 * @CreateTime: 2018/7/14 下午4:20
 */
public class RecyclerWrapper extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final int headType = 0x01;
    private final int normalType = 0x02;
    private final int footType = 0x03;
    private View headerView;
    private View footerView;
    private RecyclerView.Adapter adapter;//目标adapter
    private int mOrientation = -1;
    private OnLoadMoreListener listenerLoadMore;


    public RecyclerWrapper(RecyclerView.Adapter adapter) {
        this.adapter = adapter;
    }

    public void addHeader(View header) {
        headerView = header;
    }

    public void removeHeader() {
        headerView = null;
    }

    public void addFooter(View footer) {
        footerView = footer;
    }

    private boolean loadMore = false;


    /**
     * 根据头部尾部返回相应的type
     *
     * @param position
     * @return
     */
    @Override
    public int getItemViewType(int position) {

        //同时加了头部和尾部
        if (headerView != null && footerView != null) {

            if (position == 0) {
                return headType;//当position为0时，展示header
            }
            return checkFooterType(position);

        } else if (headerView != null) {//只有头部
            if (position == 0)
                return headType;
            if (adapter.getItemCount() > 1) {
                return adapter.getItemViewType(position);
            }
            return normalType;
        } else if (footerView != null) { //只有尾部
            return checkFooterType(position);
        } else {
            if (adapter.getItemCount() > 1) {
                return adapter.getItemViewType(position);
            }
            return normalType;
        }
    }

    //footer or content item
    private int checkFooterType(int position) {
        if (position == getItemCount() - 1) {
            return footType;//当position为最后一个时，展示footer
        } else {
            //其他时候就展示原来adapter的
            if (adapter.getItemCount() > 1) {
                return adapter.getItemViewType(position);
            }
            return normalType;
        }
    }

    /**
     * 根据getItemViewType返回的值来返回相应的ViewHolder
     * 头部和尾部的ViewHolder只是一个集成RecyclerView.ViewHolder的简单默认类，里面并没有任何处理。
     * 这样就完成了类型的返回了
     *
     * @param parent
     * @param viewType
     * @return
     */
    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == headType)//返回头部的ViewHolder
            return new HeaderViewHolder(headerView);
        else if (viewType == footType)//返回尾部的ViewHolder
            return new FoogerViewHolder(footerView);//其他就直接返回传入的adapter的ViewHolder
        return adapter.onCreateViewHolder(parent, viewType);
    }

    /**
     * 绑定ViewHolder，当是header或footer时，直接返回，因为不用绑定，
     * 当是传入的adapter时，就直接调用adapter.onBindViewHolder就行了
     *
     * @param holder
     * @param position
     */
    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (footerView != null) {
            footerView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (listenerLoadMore != null) {
                        listenerLoadMore.onClickLoadMore();
                    }
                }
            });
        }

        if (headerView != null && footerView != null)//有头部和尾部
        {
            if (holder.getAdapterPosition() == 0) {
                setStaggeredGrideFullSpan(holder.itemView);
                return;//头部直接返回，无需绑定
            } else if (holder.getAdapterPosition() == getItemCount() - 1) {
                setStaggeredGrideFullSpan(holder.itemView);
                return;//尾部直接返回，也无需绑定
            } else {
                holder.itemView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (listenerLoadMore != null) {
                            listenerLoadMore.onItemClick(v, holder.getAdapterPosition() - 1);
                        }
                    }
                });
                adapter.onBindViewHolder(holder, holder.getAdapterPosition() - 1);//其他就调用adapter的绑定方法
            }
        } else if (headerView != null) {
            if (holder.getAdapterPosition() == 0) {
                setStaggeredGrideFullSpan(holder.itemView);
                return;
            } else {
                holder.itemView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (listenerLoadMore != null) {
                            listenerLoadMore.onItemClick(v, holder.getAdapterPosition() - 1);
                        }
                    }
                });
                adapter.onBindViewHolder(holder, holder.getAdapterPosition() - 1);
            }
        } else if (footerView != null) {
            if (holder.getAdapterPosition() == getItemCount() - 1) {
                setStaggeredGrideFullSpan(holder.itemView);
                return;
            } else {
                holder.itemView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (listenerLoadMore != null) {
                            listenerLoadMore.onItemClick(v, holder.getAdapterPosition());
                        }
                    }
                });
                adapter.onBindViewHolder(holder, holder.getAdapterPosition());
            }
        } else {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (listenerLoadMore != null) {
                        listenerLoadMore.onItemClick(v, holder.getAdapterPosition());
                    }
                }
            });
            adapter.onBindViewHolder(holder, holder.getAdapterPosition());
        }
    }

    private void setStaggeredGrideFullSpan(View v) {
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (null != params && params instanceof StaggeredGridLayoutManager.LayoutParams) {
            ((StaggeredGridLayoutManager.LayoutParams) params).setFullSpan(true);
        }
    }

    /**
     * 返回item的数量，
     *
     * @return
     */
    @Override
    public int getItemCount() {

        if (headerView != null && footerView != null) {
            return adapter.getItemCount() + 2;//有头部和尾部，就多了2
        } else if (headerView != null) {
            return adapter.getItemCount() + 1;//只有头部多了1
        } else if (footerView != null) {
            return adapter.getItemCount() + 1;//只有尾部也多了1
        }
        return adapter.getItemCount();//其他就是默认的值， 不多也不少
    }

    /**
     * 头部的ViewHolder
     */
    private class HeaderViewHolder extends RecyclerView.ViewHolder {
        public HeaderViewHolder(View itemView) {
            super(itemView);
        }
    }

    /**
     * 尾部的ViewHolder
     */
    private class FoogerViewHolder extends RecyclerView.ViewHolder {
        public FoogerViewHolder(View itemView) {
            super(itemView);
        }
    }

    /**
     * 处理当错别字Gridview类型的效果时，也把头部和尾部设置成一整行
     *
     * @param recyclerView
     */
    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        final RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        mOrientation = getOrientation(layoutManager);
        if (layoutManager instanceof GridLayoutManager) {
            /**
             * getSpanSize的返回值的意思是：position位置的item的宽度占几列
             * 比如总的是4列，然后头部全部显示的话就应该占4列，此时就返回4
             * 其他的只占一列，所以就返回1，剩下的三列就由后面的item来依次填充。
             */
            ((GridLayoutManager) layoutManager).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
                @Override
                public int getSpanSize(int position) {
                    if (headerView != null && footerView != null) {
                        if (position == 0) {
                            return ((GridLayoutManager) layoutManager).getSpanCount();
                        } else if (position == getItemCount() - 1) {
                            return ((GridLayoutManager) layoutManager).getSpanCount();
                        } else {
                            return 1;
                        }
                    } else if (headerView != null) {
                        if (position == 0) {
                            return ((GridLayoutManager) layoutManager).getSpanCount();
                        }
                        return 1;
                    } else if (footerView != null) {
                        if (position == getItemCount() - 1) {
                            return ((GridLayoutManager) layoutManager).getSpanCount();
                        }
                        return 1;
                    }
                    return 1;
                }
            });

        } else {

        }
    }

    /**
     * 判断是否到底部了
     *
     * @param recyclerView
     * @return
     */
    protected boolean isSlideToBottom(RecyclerView recyclerView) {
        if (recyclerView == null) return false;
        if (mOrientation == LinearLayoutManager.VERTICAL) {
            if (recyclerView.computeVerticalScrollExtent() + recyclerView.computeVerticalScrollOffset() >= recyclerView.computeVerticalScrollRange())
                return true;
        } else {
            if (recyclerView.computeHorizontalScrollExtent() + recyclerView.computeHorizontalScrollOffset() >= recyclerView.computeHorizontalScrollRange())
                return true;
        }
        return false;
    }

    /**
     * 加载更多回调接口
     */
    public interface OnLoadMoreListener {
        void onLoadMore();

        void onClickLoadMore();

        void onItemClick(View view, int position);
    }

    private int getOrientation(RecyclerView.LayoutManager layoutManager) {
        int mOrientation = 0;
//        Class<?> clazz = null;
//        try {
//            clazz = Class.forName("androidx.recyclerview.widget.LinearLayoutManager");
//            Field field = clazz.getDeclaredField("mOrientation");
//            field.setAccessible(true);
//            mOrientation = field.getInt(layoutManager);
//        } catch (ClassNotFoundException e) {
//            e.printStackTrace();
//        } catch (IllegalAccessException e) {
//            e.printStackTrace();
//        } catch (NoSuchFieldException e) {
//            e.printStackTrace();
//        }
        if (layoutManager instanceof LinearLayoutManager)
            mOrientation = ((LinearLayoutManager) layoutManager).getOrientation();
        else if (layoutManager instanceof StaggeredGridLayoutManager)
            mOrientation = ((StaggeredGridLayoutManager) layoutManager).getOrientation();
        //else if(layoutManager instanceof GridLayoutManager)((GridLayoutManager)layoutManager).getOrientation();
        return mOrientation;
    }


    //实现加载更多接口
    //@Deprecated
    public void setOnloadMoreListener(OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView) {
        setOnLoadMoreListener(listenerLoadMore, recyclerView);
    }


    public void setOnLoadMoreListener(OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView) {
        setOnLoadMoreListener(listenerLoadMore, recyclerView, new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
//                Logger.w(loadMore, "onScrollStateChanged", newState);
                if (loadMore && newState == RecyclerView.SCROLL_STATE_IDLE) {
                    try {
                        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                        if (layoutManager instanceof LinearLayoutManager) {
                            LinearLayoutManager linearLayoutManager = ((LinearLayoutManager) layoutManager);
//                            Logger.w(linearLayoutManager.findLastVisibleItemPosition(), adapter.getItemCount() - 1);
                            if (linearLayoutManager.findLastVisibleItemPosition() >= adapter.getItemCount() - 1) {
                                loadData();
                            }
                        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager) layoutManager;
                            //获取最后一个完全显示的ItemPosition
                            int[] lastVisiblePositions = staggeredGridLayoutManager.findLastVisibleItemPositions(new int[staggeredGridLayoutManager.getSpanCount()]);
                            int lastVisiblePos = getMaxElem(lastVisiblePositions);
                            int totalItemCount = staggeredGridLayoutManager.getItemCount();

                            // 判断是否滚动到底部
                            if (lastVisiblePos >= (totalItemCount - 1)) {
                                loadData();
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private void loadData() {
                loadMore = false;
                if (null != listenerLoadMore) listenerLoadMore.onLoadMore();
            }


            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
//                Logger.w(dy);
                if (dy > 0) {
                    loadMore = true;
                } else {
                    loadMore = false;
                }
            }

        });
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView, RecyclerView.OnScrollListener listenerScroll) {

        this.listenerLoadMore = listenerLoadMore;
        if (null == recyclerView || null == listenerLoadMore) return;

        recyclerView.addOnScrollListener(listenerScroll);

//        if (recyclerView != null && listenerLoadMore != null) {
//            recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
//                @Override
//                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
//                    super.onScrollStateChanged(recyclerView, newState);
//                    if (newState == RecyclerView.SCROLL_STATE_IDLE) {
//                        final RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
//                        int lastVisiblePosition = 0;
//                        if (layoutManager instanceof LinearLayoutManager) {
//                            lastVisiblePosition = ((LinearLayoutManager) layoutManager).findLastVisibleItemPosition();
//                        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
//                            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager) layoutManager;
//                            //获取最后一个完全显示的ItemPosition
//                            int[] lastVisiblePositions = staggeredGridLayoutManager.findLastVisibleItemPositions(new int[staggeredGridLayoutManager.getSpanCount()]);
//                            lastVisiblePosition = getMaxElem(lastVisiblePositions);
//                            //int totalItemCount = staggeredGridLayoutManager.getItemCount();
//                        }
//                        if (lastVisiblePosition >= layoutManager.getItemCount() - 1 && loadMore) {
//                            loadMore = false;
//                            if (listenerLoadMore != null) {
//                                listenerLoadMore.onLoadMore();
//                            }
//                        }
//                    }
//                }
//
//                @Override
//                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
//                    super.onScrolled(recyclerView, dx, dy);
//                    if (dy > 0) {
//                        loadMore = true;
//                    } else {
//                        loadMore = false;
//                    }
//                }
//            });
//        }
    }

    private int getMaxElem(int[] arr) {
        int size = arr.length;
        int maxVal = Integer.MIN_VALUE;
        for (int i = 0; i < size; i++) {
            if (arr[i] > maxVal)
                maxVal = arr[i];
        }
        return maxVal;
    }


//    private RecyclerView.OnScrollListener listenerScroll = ;


}
