package dc.android.bridge.fragment;

import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

/**
 * @author senrsl
 * @ClassName: BaseListFragment
 * @Package: dc.android.bridge.fragment
 * @CreateTime: 2018/11/18 11:13 PM
 */
public class BaseListFragment extends BaseFragment implements SwipeRefreshLayout.OnRefreshListener {

    //方式一
    protected SwipeRefreshLayout layoutSwipe;


    protected void initSwipeLayout(SwipeRefreshLayout swipeLayout) {
        if (null == swipeLayout) return;
        this.layoutSwipe = swipeLayout;
        swipeLayout.setDistanceToTriggerSync(300);
        swipeLayout.setOnRefreshListener(this);
    }


    @Override
    public void refreshDataOnCreated() {
        super.refreshDataOnCreated();

    }

    protected void showRefreshing() {
        if (null != layoutSwipe) layoutSwipe.setRefreshing(true);
    }

    public void cancelRefresh() {
        if (null != layoutSwipe && layoutSwipe.isRefreshing()) layoutSwipe.setRefreshing(false);
    }

    protected boolean isRefreshing() {
        return null == layoutSwipe ? false : layoutSwipe.isRefreshing();
    }

    protected void disableSwipe() {
        if (null == layoutSwipe) return;
        layoutSwipe.setEnabled(false);
    }

    protected void enableSwipe() {
        if (null == layoutSwipe) return;
        layoutSwipe.setEnabled(true);
    }


    /**
     * 仅适用swipeLayout模式
     */
    @Override
    public void onRefresh() {
        if (null != layoutSwipe && layoutSwipe.isRefreshing()) return;
    }


}
