package dc.android.bridge.fragment;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import dc.android.bridge.adapter.wrapper.RecyclerWrapper;
import dc.android.common.BridgeOpcode;

/**
 * @author senrsl
 * @ClassName: BaseListWrapperFragment
 * @Package: dc.android.bridge.fragment
 * @CreateTime: 2018/11/22 6:16 PM
 */
public class BaseListWrapperFragment extends BaseFragment implements RecyclerWrapper.OnLoadMoreListener {

    //方式二
    private LinearLayout layoutHeader, layoutFooter;


    protected void initWrapperLayout(LinearLayout layoutHeader, LinearLayout layoutFooter) {
        this.layoutHeader = layoutHeader;
        this.layoutFooter = layoutFooter;
    }


    //方式二，通过设置高度的方式显示
    protected void setHeight(int headerHeight, int footerHeight) {
        setHeightHeader(headerHeight);
        setHeightFooter(footerHeight);

    }

    protected void setHeightHeader(int headerHeight) {
        if (headerHeight == BridgeOpcode.DEFAULT) return;
        ViewGroup.LayoutParams paramsHeader = layoutHeader.getLayoutParams();
        paramsHeader.height = headerHeight;
        layoutHeader.setLayoutParams(paramsHeader);
    }

    protected void setHeightFooter(int footerHeight) {
        if (footerHeight == BridgeOpcode.DEFAULT) return;
        ViewGroup.LayoutParams paramsFooter = layoutFooter.getLayoutParams();
        paramsFooter.height = footerHeight;
        layoutFooter.setLayoutParams(paramsFooter);
    }


    public void cancelRefresh() {
        setHeightHeader(0);
    }

    @Override
    public void onLoadMore() {

    }

    @Override
    public void onClickLoadMore() {

    }

    @Override
    public void onItemClick(View view, int position) {

    }
}
