/*
 * Decompiled with CFR 0.152.
 */
package dc.android.bridge.adapter.wrapper;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class RecyclerWrapper
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int headType = 1;
    private final int normalType = 2;
    private final int footType = 3;
    private View headerView;
    private View footerView;
    private RecyclerView.Adapter adapter;
    private int mOrientation = -1;
    private OnLoadMoreListener listenerLoadMore;
    private boolean loadMore = false;

    public RecyclerWrapper(RecyclerView.Adapter adapter) {
        this.adapter = adapter;
    }

    public void addHeader(View header) {
        this.headerView = header;
    }

    public void removeHeader() {
        this.headerView = null;
    }

    public void addFooter(View footer) {
        this.footerView = footer;
    }

    public int getItemViewType(int position) {
        if (this.headerView != null && this.footerView != null) {
            if (position == 0) {
                return 1;
            }
            return this.checkFooterType(position);
        }
        if (this.headerView != null) {
            if (position == 0) {
                return 1;
            }
            if (this.adapter.getItemCount() > 1) {
                return this.adapter.getItemViewType(position);
            }
            return 2;
        }
        if (this.footerView != null) {
            return this.checkFooterType(position);
        }
        if (this.adapter.getItemCount() > 1) {
            return this.adapter.getItemViewType(position);
        }
        return 2;
    }

    private int checkFooterType(int position) {
        if (position == this.getItemCount() - 1) {
            return 3;
        }
        if (this.adapter.getItemCount() > 1) {
            return this.adapter.getItemViewType(position);
        }
        return 2;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new HeaderViewHolder(this.headerView);
        }
        if (viewType == 3) {
            return new FoogerViewHolder(this.footerView);
        }
        return this.adapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        if (this.footerView != null) {
            this.footerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerWrapper.this.listenerLoadMore != null) {
                        RecyclerWrapper.this.listenerLoadMore.onClickLoadMore();
                    }
                }
            });
        }
        if (this.headerView != null && this.footerView != null) {
            if (holder.getAdapterPosition() == 0) {
                this.setStaggeredGrideFullSpan(holder.itemView);
                return;
            }
            if (holder.getAdapterPosition() == this.getItemCount() - 1) {
                this.setStaggeredGrideFullSpan(holder.itemView);
                return;
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerWrapper.this.listenerLoadMore != null) {
                        RecyclerWrapper.this.listenerLoadMore.onItemClick(v, holder.getAdapterPosition() - 1);
                    }
                }
            });
            this.adapter.onBindViewHolder(holder, holder.getAdapterPosition() - 1);
        } else if (this.headerView != null) {
            if (holder.getAdapterPosition() == 0) {
                this.setStaggeredGrideFullSpan(holder.itemView);
                return;
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerWrapper.this.listenerLoadMore != null) {
                        RecyclerWrapper.this.listenerLoadMore.onItemClick(v, holder.getAdapterPosition() - 1);
                    }
                }
            });
            this.adapter.onBindViewHolder(holder, holder.getAdapterPosition() - 1);
        } else if (this.footerView != null) {
            if (holder.getAdapterPosition() == this.getItemCount() - 1) {
                this.setStaggeredGrideFullSpan(holder.itemView);
                return;
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerWrapper.this.listenerLoadMore != null) {
                        RecyclerWrapper.this.listenerLoadMore.onItemClick(v, holder.getAdapterPosition());
                    }
                }
            });
            this.adapter.onBindViewHolder(holder, holder.getAdapterPosition());
        } else {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RecyclerWrapper.this.listenerLoadMore != null) {
                        RecyclerWrapper.this.listenerLoadMore.onItemClick(v, holder.getAdapterPosition());
                    }
                }
            });
            this.adapter.onBindViewHolder(holder, holder.getAdapterPosition());
        }
    }

    private void setStaggeredGrideFullSpan(View v) {
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (null != params && params instanceof StaggeredGridLayoutManager.LayoutParams) {
            ((StaggeredGridLayoutManager.LayoutParams)params).setFullSpan(true);
        }
    }

    public int getItemCount() {
        if (this.headerView != null && this.footerView != null) {
            return this.adapter.getItemCount() + 2;
        }
        if (this.headerView != null) {
            return this.adapter.getItemCount() + 1;
        }
        if (this.footerView != null) {
            return this.adapter.getItemCount() + 1;
        }
        return this.adapter.getItemCount();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        final RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        this.mOrientation = this.getOrientation(layoutManager);
        if (layoutManager instanceof GridLayoutManager) {
            ((GridLayoutManager)layoutManager).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (RecyclerWrapper.this.headerView != null && RecyclerWrapper.this.footerView != null) {
                        if (position == 0) {
                            return ((GridLayoutManager)layoutManager).getSpanCount();
                        }
                        if (position == RecyclerWrapper.this.getItemCount() - 1) {
                            return ((GridLayoutManager)layoutManager).getSpanCount();
                        }
                        return 1;
                    }
                    if (RecyclerWrapper.this.headerView != null) {
                        if (position == 0) {
                            return ((GridLayoutManager)layoutManager).getSpanCount();
                        }
                        return 1;
                    }
                    if (RecyclerWrapper.this.footerView != null) {
                        if (position == RecyclerWrapper.this.getItemCount() - 1) {
                            return ((GridLayoutManager)layoutManager).getSpanCount();
                        }
                        return 1;
                    }
                    return 1;
                }
            });
        }
    }

    protected boolean isSlideToBottom(RecyclerView recyclerView) {
        if (recyclerView == null) {
            return false;
        }
        return this.mOrientation == 1 ? recyclerView.computeVerticalScrollExtent() + recyclerView.computeVerticalScrollOffset() >= recyclerView.computeVerticalScrollRange() : recyclerView.computeHorizontalScrollExtent() + recyclerView.computeHorizontalScrollOffset() >= recyclerView.computeHorizontalScrollRange();
    }

    private int getOrientation(RecyclerView.LayoutManager layoutManager) {
        int mOrientation = 0;
        if (layoutManager instanceof LinearLayoutManager) {
            mOrientation = ((LinearLayoutManager)layoutManager).getOrientation();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            mOrientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        }
        return mOrientation;
    }

    public void setOnloadMoreListener(OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView) {
        this.setOnLoadMoreListener(listenerLoadMore, recyclerView);
    }

    public void setOnLoadMoreListener(final OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView) {
        this.setOnLoadMoreListener(listenerLoadMore, recyclerView, new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (RecyclerWrapper.this.loadMore && newState == 0) {
                    try {
                        int totalItemCount;
                        StaggeredGridLayoutManager staggeredGridLayoutManager;
                        int[] lastVisiblePositions;
                        int lastVisiblePos;
                        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                        if (layoutManager instanceof LinearLayoutManager) {
                            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                            if (linearLayoutManager.findLastVisibleItemPosition() >= RecyclerWrapper.this.adapter.getItemCount() - 1) {
                                this.loadData();
                            }
                        } else if (layoutManager instanceof StaggeredGridLayoutManager && (lastVisiblePos = RecyclerWrapper.this.getMaxElem(lastVisiblePositions = (staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(new int[staggeredGridLayoutManager.getSpanCount()]))) >= (totalItemCount = staggeredGridLayoutManager.getItemCount()) - 1) {
                            this.loadData();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private void loadData() {
                RecyclerWrapper.this.loadMore = false;
                if (null != listenerLoadMore) {
                    listenerLoadMore.onLoadMore();
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (dy > 0) {
                    RecyclerWrapper.this.loadMore = true;
                } else {
                    RecyclerWrapper.this.loadMore = false;
                }
            }
        });
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listenerLoadMore, RecyclerView recyclerView, RecyclerView.OnScrollListener listenerScroll) {
        this.listenerLoadMore = listenerLoadMore;
        if (null == recyclerView || null == listenerLoadMore) {
            return;
        }
        recyclerView.addOnScrollListener(listenerScroll);
    }

    private int getMaxElem(int[] arr) {
        int size = arr.length;
        int maxVal = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            if (arr[i] <= maxVal) continue;
            maxVal = arr[i];
        }
        return maxVal;
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore();

        public void onClickLoadMore();

        public void onItemClick(View var1, int var2);
    }

    private class FoogerViewHolder
    extends RecyclerView.ViewHolder {
        public FoogerViewHolder(View itemView) {
            super(itemView);
        }
    }

    private class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderViewHolder(View itemView) {
            super(itemView);
        }
    }
}

