/*
 * Decompiled with CFR 0.152.
 */
package dc.common.log;

import android.content.Context;
import dc.common.log.LoggerSave;
import dc.common.log.LoggerSaveCat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LoggerSaveManager {
    private static Map<String, LoggerSave> map = new HashMap<String, LoggerSave>();
    protected static boolean isSave = false;
    protected static boolean isSaveTime = false;
    public static SimpleDateFormat sdf = new SimpleDateFormat();
    private static LoggerSaveCat lsc;

    public static LoggerSave get() {
        return LoggerSaveManager.get(null);
    }

    public static LoggerSave get(String name) {
        if (null == name || "".equals(name)) {
            return map.get(0);
        }
        return map.get(name);
    }

    public static void setSave(boolean isSave) {
        LoggerSaveManager.isSave = isSave;
    }

    public static void setSaveTime(boolean isSaveTime) {
        LoggerSaveManager.setSaveTime(isSaveTime, "yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static void setSaveTime(boolean isSaveTime, String format) {
        LoggerSaveManager.isSaveTime = isSaveTime;
        sdf = new SimpleDateFormat(format);
    }

    public static int start(Context ctx) {
        isSave = true;
        return LoggerSaveManager.create(ctx);
    }

    public static int start(Context ctx, String logPath, String logName) {
        isSave = true;
        return LoggerSaveManager.create(ctx, logPath, logName);
    }

    public static int create(Context ctx) {
        return LoggerSaveManager.create(ctx, null, null);
    }

    public static int create(Context ctx, String logPath, String logName) {
        if (map.containsKey(logName)) {
            return map.size();
        }
        LoggerSave ls = new LoggerSave(ctx, logPath, logName);
        map.put(logName, ls);
        return map.size();
    }

    public static void save(String name, String str) {
        try {
            map.get(name).save(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String appendSaveTime(String str) {
        if (isSaveTime) {
            return String.format("%s %s", sdf.format(new Date()), str);
        }
        return str;
    }

    public static void startCat(Context ctx) {
        LoggerSaveManager.startCat(ctx, null, null);
    }

    public static void startCat(Context ctx, String logPath, String logName) {
        try {
            if (null == lsc) {
                lsc = new LoggerSaveCat(ctx, logPath, logName);
            }
            lsc.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopCat() {
        if (null != lsc) {
            lsc.stop();
        }
    }
}

