/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.net;

import android.net.Uri;
import android.os.Build;
import dc.android.common.NetContext;
import dc.android.common.net.SSLSocketFactoryCompat;
import dc.common.Logger;
import dc.common.utils.StreamUtils;
import dc.common.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.X509TrustManager;

public class WebClient {
    private String uri;
    private String msg;
    private Map<String, Object> mapData;
    private String method = "GET";
    private int readTimeout = 10000;
    private int connectTimeout = 10000;
    private boolean isUseCache = false;
    private String contentType = null;
    private String charsetName = "UTF-8";
    private boolean isSupportPut = false;
    private String result = "";

    public WebClient setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public WebClient setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public WebClient setMapData(Map<String, Object> mapData) {
        this.mapData = mapData;
        return this;
    }

    public Map<String, Object> getMapData() {
        return this.mapData;
    }

    public WebClient setMethod(String method) {
        this.method = method;
        return this;
    }

    public WebClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public WebClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public WebClient setUseCache(boolean useCache) {
        this.isUseCache = useCache;
        return this;
    }

    public WebClient setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public WebClient setSupportPut(boolean supportPut) {
        this.isSupportPut = supportPut;
        return this;
    }

    public WebClient setCharsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    protected HttpURLConnection getHttpConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn;
    }

    protected HttpsURLConnection getHttpsConnection(URL url) throws IOException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        return conn;
    }

    protected void setHeader(HttpURLConnection conn) throws ProtocolException {
        conn.setRequestMethod(this.method);
        conn.setReadTimeout(this.readTimeout);
        conn.setConnectTimeout(this.connectTimeout);
        if (this.isSupportPut) {
            conn.setDoOutput(true);
            conn.setDoInput(true);
        }
        conn.setUseCaches(this.isUseCache);
        if (NetContext.CONTENT_TYPE_FORM_DATA.equals(this.contentType)) {
            conn.setRequestProperty(NetContext.CONTENT_TYPE, String.format(NetContext.BOUNDARY_TYPE_FORMAT, this.contentType, NetContext.BOUNDARY));
        } else {
            conn.setRequestProperty(NetContext.CONTENT_TYPE, this.contentType);
        }
    }

    protected void write(HttpURLConnection conn) throws IOException {
        if (!"POST".equalsIgnoreCase(this.method)) {
            return;
        }
        OutputStream os = conn.getOutputStream();
        if (NetContext.CONTENT_TYPE_JSON.equals(this.contentType)) {
            if (StringUtils.isEmpty((String)this.msg)) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charsetName));
            writer.write(this.msg);
            writer.close();
        } else if (NetContext.CONTENT_TYPE_FORM_ENCODED.equals(this.contentType)) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.charsetName));
            if (!StringUtils.isEmpty((String)this.msg)) {
                writer.write(this.msg);
            }
            if (null != this.mapData && !this.mapData.isEmpty()) {
                if (!StringUtils.isEmpty((String)this.msg) && this.msg.indexOf("=") != -1) {
                    writer.write("&");
                }
                writer.write(this.generateEncodeParams(this.mapData));
            }
            writer.close();
        } else if (NetContext.CONTENT_TYPE_FORM_DATA.equals(this.contentType)) {
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, this.charsetName), true);
            writer.write(NetContext.LINE_RN);
            if (!StringUtils.isEmpty((String)this.msg)) {
                writer.append(NetContext.BOUNDARY_GAIN).append(NetContext.BOUNDARY).append(NetContext.LINE_RN);
                writer.append(String.format(NetContext.BOUNDARY_FORMAT_TEXT, NetContext.KEY_MSG, this.msg));
                writer.flush();
            }
            if (null != this.mapData && !this.mapData.isEmpty()) {
                for (String key : this.mapData.keySet()) {
                    int length;
                    File file;
                    Object value = this.mapData.get(key);
                    if (value instanceof String) {
                        writer.append(NetContext.BOUNDARY_GAIN).append(NetContext.BOUNDARY).append(NetContext.LINE_RN);
                        writer.append(String.format(NetContext.BOUNDARY_FORMAT_TEXT, key, String.valueOf(value)));
                        writer.flush();
                        continue;
                    }
                    if (!(value instanceof File) || !(file = (File)value).exists()) continue;
                    writer.append(NetContext.BOUNDARY_GAIN).append(NetContext.BOUNDARY).append(NetContext.LINE_RN);
                    writer.append(String.format(NetContext.BOUNDARY_FORMAT_FILE, key));
                    writer.append(NetContext.CONTENT_TYPE).append(":").append(" ").append(URLConnection.guessContentTypeFromName(key)).append(NetContext.LINE_RN);
                    writer.append(NetContext.LINE_RN);
                    writer.flush();
                    FileInputStream is = new FileInputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                    os.flush();
                    ((InputStream)is).close();
                    writer.append(NetContext.LINE_RN);
                    writer.flush();
                }
            }
            if (!StringUtils.isEmpty((String)this.msg) || null != this.mapData && !this.mapData.isEmpty()) {
                writer.append(NetContext.BOUNDARY_GAIN).append(NetContext.BOUNDARY).append(NetContext.BOUNDARY_GAIN).append(NetContext.LINE_RN);
                writer.flush();
            }
            writer.close();
        }
    }

    protected String read(HttpURLConnection conn) throws IOException {
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = conn.getInputStream();
            this.result = StreamUtils.is2string(inputStream, this.charsetName);
        }
        Logger.w((String)this.result);
        return this.result;
    }

    public String request() throws IOException {
        this.processGetUri();
        String result = Build.VERSION.SDK_INT > 19 ? this.requestHttp() : this.requestHttps();
        return result;
    }

    private void processGetUri() {
        if (!"GET".equalsIgnoreCase(this.method)) {
            return;
        }
        if (!StringUtils.isEmpty((String)this.msg)) {
            this.uri = this.uri.concat(this.uri.indexOf("?") == -1 ? "?" : "").concat(this.uri.indexOf("=") == -1 ? "" : "&").concat(this.msg);
        }
        if (null != this.mapData && !this.mapData.isEmpty()) {
            this.uri = this.uri.concat(this.uri.indexOf("?") == -1 ? "?" : "").concat(this.uri.indexOf("=") == -1 ? "" : "&").concat(this.generateEncodeParams(this.mapData));
        }
        Logger.w((String)this.uri);
    }

    public String generateEncodeParams(Map<String, Object> map) {
        if (null == map) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(Uri.encode((String)key)).append("=").append(Uri.encode((String)String.valueOf(map.get(key))));
        }
        return sb.toString();
    }

    public String requestHttp() throws IOException {
        URL url = new URL(this.uri);
        HttpURLConnection conn = this.getHttpConnection(url);
        this.setHeader(conn);
        conn.connect();
        this.write(conn);
        return this.read(conn);
    }

    public String requestHttps() throws IOException {
        URL url = new URL(this.uri);
        HttpsURLConnection conn = this.getHttpsConnection(url);
        this.setHeader(conn);
        this.fixProtocol19(conn);
        conn.connect();
        this.write(conn);
        return this.read(conn);
    }

    @Deprecated
    protected void fixProtocol19(HttpsURLConnection conn) {
        if (Build.VERSION.SDK_INT > 19) {
            return;
        }
        X509TrustManager trustAllCert = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        conn.setSSLSocketFactory(new SSLSocketFactoryCompat(trustAllCert));
    }
}

