/*
 * Decompiled with CFR 0.152.
 */
package dc.common.trans.socket;

import dc.common.Global;
import dc.common.trans.socket.ChannelSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SocketKeep
extends ChannelSocket {
    public SocketKeep(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    @Override
    public int init() {
        try {
            if (this.client == null || !this.client.isOpen()) {
                this.client = SocketChannel.open();
                this.client.configureBlocking(false);
                this.selector = Selector.open();
                this.client.register(this.selector, 8);
            }
            if (!this.client.isConnected() && !this.client.connect(new InetSocketAddress(this.host, this.port))) {
                int i = 0;
                while (!this.client.finishConnect()) {
                    if (++i >= 100) {
                        this.client.close();
                        this.client = null;
                        return 5016;
                    }
                    Thread.sleep(10L);
                }
            }
        }
        catch (ClosedChannelException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5013;
        }
        catch (IOException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5014;
        }
        catch (InterruptedException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5014;
        }
        return 2000;
    }

    @Override
    public int close() {
        try {
            this.client.close();
            this.client = null;
        }
        catch (IOException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5015;
        }
        return 2000;
    }

    @Override
    public int httpSocket(byte[] b, ByteArrayOutputStream baos) {
        if (b == null || b.length <= 0) {
            return 5017;
        }
        try {
            this.init();
            try {
                ByteBuffer readBuf = ByteBuffer.allocate(1024);
                if (this.client.read(readBuf) <= -1) {
                    this.close();
                    return this.httpSocket(b, baos);
                }
            }
            catch (ClosedChannelException e) {
                this.close();
                return 5013;
            }
            ByteBuffer writeBuf = ByteBuffer.wrap(b);
            this.client.write(writeBuf);
            ByteBuffer readBuf = ByteBuffer.allocate(1024);
            for (int i = 0; i <= 50; ++i) {
                if (i >= 20) {
                    return 5010;
                }
                int readSize = this.client.read(readBuf);
                if (readSize > 0) {
                    baos.write(readBuf.array(), 0, readSize);
                    break;
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            this.client = null;
            return 3100;
        }
        return 2000;
    }
}

