/*
 * Decompiled with CFR 0.152.
 */
package dc.common.trans.socket;

import dc.common.Global;
import dc.common.Logger;
import dc.common.trans.socket.ChannelSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SocketSingle
extends ChannelSocket {
    public SocketSingle(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    @Override
    public int httpSocket(byte[] b, ByteArrayOutputStream baos) {
        block14: {
            long sum = 0L;
            try {
                ByteBuffer buffer;
                SelectionKey key;
                block15: {
                    this.init();
                    block2: while (true) {
                        if (this.selector.select(this.timeout * 2 * 1000) == 0) {
                            if (this.selector.isOpen()) {
                                this.selector.close();
                            }
                            this.client.close();
                            Logger.w((String)"\u4fe1\u9053\u672a\u51c6\u5907\u5c31\u7eea");
                            return 5011;
                        }
                        Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                        do {
                            int shijian;
                            if (!iter.hasNext()) continue block2;
                            key = iter.next();
                            iter.remove();
                            if (key.isConnectable()) {
                                SocketChannel channel = (SocketChannel)key.channel();
                                if (channel.isConnectionPending()) {
                                    channel.finishConnect();
                                }
                                channel.write(ByteBuffer.wrap(b));
                                channel.register(this.selector, 1);
                            }
                            if ((shijian = this.selector.select(this.timeout * 2 * 1000)) == 0) {
                                if (this.selector.isOpen()) {
                                    this.selector.close();
                                }
                                this.client.close();
                                return 5011;
                            }
                            Logger.w((String)("\u5206" + key.isReadable()));
                        } while (!key.isReadable());
                        break;
                    }
                    SocketChannel channel = (SocketChannel)key.channel();
                    byte[] by = new byte[1024];
                    buffer = ByteBuffer.wrap(by);
                    int resultLen = 0;
                    while (true) {
                        buffer.clear();
                        int n = channel.read(buffer);
                        if (n > 0) {
                            buffer.flip();
                            baos.write(buffer.array(), 0, n);
                            buffer.clear();
                            if ((sum += (long)n) == (long)resultLen) {
                                this.selector.close();
                                key.cancel();
                                buffer.clear();
                                this.client.close();
                                break block14;
                            }
                            Logger.w((String)"has waiting...");
                            continue;
                        }
                        if (n != 0) break block15;
                        if (sum == (long)resultLen) break;
                    }
                    this.selector.close();
                    key.cancel();
                    buffer.clear();
                    this.client.close();
                    break block14;
                }
                Logger.w((String)"client close connect");
                this.selector.close();
                key.cancel();
                buffer.clear();
                this.client.close();
            }
            catch (Exception e) {
                if (Global.isDebug) {
                    e.printStackTrace();
                }
                this.close();
                return 5010;
            }
        }
        return 2000;
    }

    @Override
    public int init() {
        try {
            if (null == this.client || !this.client.isOpen()) {
                this.client = SocketChannel.open();
                this.client.configureBlocking(false);
            }
            if (null == this.ip) {
                this.ip = new InetSocketAddress(this.host, this.port);
            }
            if (this.ip.isUnresolved()) {
                this.client.close();
                Logger.w((String)"\u627e\u4e0d\u5230\u5730\u5740");
                return 5011;
            }
            if (!this.client.isConnected()) {
                this.client.connect(this.ip);
            }
            if (null == this.selector || !this.selector.isOpen()) {
                this.selector = Selector.open();
            }
            if (!this.client.isRegistered()) {
                this.client.register(this.selector, 8);
            }
        }
        catch (ClosedChannelException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5011;
        }
        catch (IOException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5011;
        }
        return 2000;
    }

    @Override
    public int close() {
        try {
            if (this.selector != null) {
                if (this.selector.isOpen()) {
                    this.selector.close();
                }
                if (this.client.isOpen()) {
                    this.client.close();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return 5010;
        }
        return 2000;
    }
}

