/*
 * Decompiled with CFR 0.152.
 */
package dc.common.trans.socket;

import dc.common.Global;
import dc.common.Logger;
import dc.common.trans.socket.ChannelSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SocketStay
extends ChannelSocket {
    int tempRet;

    public SocketStay(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    @Override
    public int init() {
        try {
            if (null == this.ip) {
                this.ip = new InetSocketAddress(this.host, this.port);
            }
            if (this.ip.isUnresolved()) {
                this.client.close();
                return 5012;
            }
            if (null == this.client || !this.client.isOpen()) {
                this.client = SocketChannel.open();
                this.client.configureBlocking(false);
            }
            if (!this.client.isConnected()) {
                this.client.connect(this.ip);
            }
            if (null == this.selector || !this.selector.isOpen()) {
                this.selector = Selector.open();
            }
            Logger.w((String)("\u4fe1\u9053\u662f\u5426\u6ce8\u518c\uff1a" + this.client.isRegistered()));
            if (!this.client.isRegistered()) {
                this.client.register(this.selector, 8);
            }
        }
        catch (ClosedChannelException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5013;
        }
        catch (IOException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5014;
        }
        return 2000;
    }

    @Override
    public int close() {
        try {
            if (this.selector != null && this.selector.isOpen()) {
                this.selector.close();
            }
            if (null != this.client && this.client.isOpen()) {
                this.client.close();
            }
        }
        catch (IOException e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            return 5015;
        }
        return 2000;
    }

    @Override
    public int httpSocket(byte[] b, ByteArrayOutputStream baos) {
        try {
            int n;
            ByteBuffer buffer;
            SocketChannel channel;
            this.tempRet = this.init();
            if (2000 != this.tempRet) {
                return this.tempRet;
            }
            block2: while (true) {
                if (2000 != (this.tempRet = this.timeout())) {
                    return this.tempRet;
                }
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isConnectable()) {
                        channel = (SocketChannel)key.channel();
                        if (channel.isConnectionPending()) {
                            channel.finishConnect();
                        }
                        channel.write(ByteBuffer.wrap(b));
                        channel.register(this.selector, 1);
                    }
                    if (2000 != (this.tempRet = this.timeout())) {
                        return this.tempRet;
                    }
                    Logger.w((String)("\u5199\uff1a" + key.isWritable()));
                    if (key.isWritable()) {
                        channel = (SocketChannel)key.channel();
                        channel.write(ByteBuffer.wrap(b));
                        channel.register(this.selector, 1);
                    }
                    Logger.w((String)("\u8bfb\uff1a" + key.isReadable()));
                    if (!key.isReadable()) continue;
                    channel = (SocketChannel)key.channel();
                    byte[] by = new byte[1024];
                    buffer = ByteBuffer.wrap(by);
                    buffer.clear();
                    n = channel.read(buffer);
                    if (n > 0) break block2;
                }
                break;
            }
            buffer.flip();
            baos.write(buffer.array(), 0, n);
            buffer.clear();
            channel.register(this.selector, 4);
        }
        catch (Exception e) {
            if (Global.isDebug) {
                e.printStackTrace();
            }
            this.close();
            return 3100;
        }
        return 2000;
    }

    private int timeout() throws IOException {
        if (this.selector.select(this.timeout * 2 * 1000) == 0) {
            this.close();
            Logger.w((String)"\u4fe1\u9053\u672a\u51c6\u5907\u5c31\u7eea,\u8fde\u63a5\u8d85\u65f6");
            return 5016;
        }
        return 2000;
    }
}

