/*
 * Decompiled with CFR 0.152.
 */
package dc.common.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String str2File(String path, String context) throws FileNotFoundException, IOException {
        OutputStream out = null;
        File file = null;
        if (null != context && null != path) {
            OutputStreamWriter osw = null;
            try {
                file = new File(path);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                out = new FileOutputStream(path);
                osw = new OutputStreamWriter(out);
                osw.write(context);
            }
            finally {
                if (null != osw) {
                    osw.close();
                }
                if (null != out) {
                    out.close();
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2Str(String filePath) throws IOException {
        StringBuffer sb = new StringBuffer();
        File filename = new File(filePath);
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            reader = new InputStreamReader(new FileInputStream(filename));
            br = new BufferedReader(reader);
            String line = "";
            line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        finally {
            if (null != br) {
                br.close();
            }
            if (null != reader) {
                reader.close();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2Byte(String filePath) throws FileNotFoundException, IOException {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            int n;
            File file = new File(filePath);
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
        }
        finally {
            if (null != fis) {
                fis.close();
            }
            if (null != bos) {
                bos.close();
            }
        }
        buffer = bos.toByteArray();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byte2File(byte[] buf, int offset, int length, String filePath, String fileName) throws FileNotFoundException, IOException {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        String filePathAbs = new StringBuffer(filePath).append(File.separator).append(fileName).toString();
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePathAbs);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            ((BufferedOutputStream)bos).write(buf, offset, length);
        }
        finally {
            if (null != bos) {
                bos.close();
            }
            if (null != fos) {
                fos.close();
            }
        }
        return filePathAbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byte2File(byte[] buf, int offset, int length, String filePath) throws FileNotFoundException, IOException {
        File file = new File(filePath);
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            if (file.exists()) {
                file.delete();
            } else if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            ((BufferedOutputStream)bos).write(buf, offset, length);
        }
        finally {
            if (null != bos) {
                bos.close();
            }
            if (null != fos) {
                fos.close();
            }
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String is2File(InputStream is, String filepath) throws FileNotFoundException, IOException {
        File file = new File(filepath);
        OutputStream os = null;
        try {
            int len;
            if (file.exists()) {
                file.delete();
            } else if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            byte[] bs = new byte[1024];
            os = new FileOutputStream(filepath);
            while ((len = is.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        finally {
            if (null != os) {
                os.close();
            }
            if (null != is) {
                is.close();
            }
        }
        return filepath;
    }

    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : FileUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtils.formatFileSize(blockSize);
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    public static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtils.getFileSizes(flist[i]);
                continue;
            }
            size += FileUtils.getFileSize(flist[i]);
        }
        return size;
    }

    public static boolean isInScope(String path, long max, long min) throws Exception {
        return FileUtils.isInScope(FileUtils.getFileSize(new File(path)), max, min);
    }

    public static boolean isInScope(long size, long max, long min) {
        return size > min && size < max;
    }

    public static String formatFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }
}

