package dc.android.arch.present;

import android.content.Context;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

/**
 * @author senrsl
 * @ClassName: BasePresenter
 * @Package: dc.android.arch.present
 * @CreateTime: 2018/7/28 下午2:34
 */
public class BasePresenter<V extends IBaseView> implements IBasePresenter<V> {


    protected Context ctx;

    private Reference<V> mViewRef;

//    /**
//     * 绑定view，一般在初始化中调用该方法
//     */
//    @Override
//    public void attachView(V view) {
//        attachView(null,view);
//    }

    @Override
    public void attachView(Context ctx, V view) {
        this.ctx = ctx;
        mViewRef = new WeakReference<>(view);
    }

    @Override
    public V getView() {
        return mViewRef.get();
    }

    /**
     * 是否与View建立连接
     * 每次调用业务请求的时候都要出先调用方法检查是否与View建立连接
     */
    @Override
    public boolean isViewAttached() {
        return mViewRef != null && mViewRef.get() != null;
    }

    /**
     * 断开view，一般在onDestroy中调用
     */
    @Override
    public void detachView() {
        if (mViewRef != null) {
            mViewRef.clear();
            mViewRef = null;
        }
    }

}
