/**
 * Filename:    NetUtils.java
 * Description:
 * Copyright:   Copyright (c)2015
 * Company:
 *
 * @author: senRsl senRsl@163.com
 * @version: 1.0
 * Create at:   2015年5月25日 下午6:03:11
 * <p>
 * Modification History:
 * Date             Author      Version     Description
 * ------------------------------------------------------------------
 * 2015年5月25日   senRsl      1.0            1.0 Version
 */
package dc.android.common.utils;

import java.util.Map;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import dc.android.common.CoreOpcode;
import dc.common.Global;
import dc.common.Logger;

/**
 * 网络
 *
 * @author senrsl
 */
public class NetUtils {

//	private static boolean networkFlag = false;

    /**
     * 是否存在可用连接
     *
     * @param context
     * @return
     */
    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = getNetworkInfo(context);
        if (null != networkInfo) return networkInfo.isAvailable();
        return false;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            return mNetworkInfo;
        }
        return null;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo networkInfo = getNetworkInfo(context);
        if (null != networkInfo) return networkInfo.getType();
        return CoreOpcode.DEFAULT;
    }

    public static boolean isWifi(Context context) {
        return getNetworkType(context) == ConnectivityManager.TYPE_WIFI;
    }


    public static boolean isHttps(String url) {
        if (null != url && url.startsWith(Global.TRANS_HEAD_HTTPS)) return true;
        return false;
    }

    public static boolean isHttp(String url) {
        if (null != url && url.startsWith(Global.TRANS_HEAD_HTTP)) return true;
        return false;
    }

    public static boolean isUrl(String url) {
        if (isHttp(url)) return true;
        return false;
    }

    public static String parseGetUrl(String url, Map<String, String> map) {
        StringBuffer sb = new StringBuffer(url);
        for (String key : map.keySet()) {
            sb.append("&").append(key).append("=").append(map.get(key));
        }
        Logger.w("parse: " + sb.toString().replaceFirst("&", "?"));
        return sb.toString().replaceFirst("&", "?");
    }

    public static String formatUrl(String url, Object... str) {
        return String.format(url, str);
    }

    public static String cleanNet(String str) {
//		return str.replace("http://", "头").replace("t.cn", "短").replace("/", "斜").replace("\\", "反斜").replace(":", "冒").replace("\'", "单").replace("\"", "").replaceAll("\\d+", "数").replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
        return str.replace("http://", "").replace("www.", "").replace(".com", "").replace(".cn", "").replace("/", "").replace("\\", "").replace(":", "").replace("\'", "").replace("\"", "").replaceAll("\\d+", "").replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
    }

}
