/**
 * Filename:    FileUtils.java
 * Description:
 * Copyright:   Copyright (c)2016
 * Company:
 *
 * @author: senRsl senRsl@163.com
 * @version: 1.0
 * Create at:   2016年3月21日 下午1:47:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016年3月21日   senRsl      1.0         1.0 Version
 */
package dc.common.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;

/**
 * 文件操作
 *
 * @author senrsl
 * <br/>finally改设2016年04月20日14:32:51
 */
public class FileUtils {

    /**
     * 存储文本到本地文件
     *
     * @param path    路径
     * @param context 待存储文本
     * @return null/file
     */
    public static String str2File(String path, String context) throws FileNotFoundException, IOException {
        OutputStream out = null;
        File file = null;
        if (null != context && null != path) {
            OutputStreamWriter osw = null;
            try {
                file = new File(path);
                if (!file.getParentFile().exists()) file.getParentFile().mkdirs();
                out = new FileOutputStream(path);
                osw = new OutputStreamWriter(out);
                osw.write(context);
            } finally {
                if (null != osw) osw.close();
                if (null != out) out.close();
            }
        }
        return path;
    }

    public static String file2Str(String filePath) throws IOException {
        StringBuffer sb = new StringBuffer();
        File filename = new File(filePath);
        InputStreamReader reader = null;
        BufferedReader br = null;
        try {
            reader = new InputStreamReader(new FileInputStream(filename));
            br = new BufferedReader(reader);
            String line = "";
            line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        } finally {
            if (null != br) br.close();
            if (null != reader) reader.close();
        }

        return sb.toString();
    }

    public static byte[] file2Byte(String filePath) throws FileNotFoundException, IOException {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            File file = new File(filePath);
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int n;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
        } finally {
            if (null != fis) fis.close();
            if (null != bos) bos.close();
        }
        buffer = bos.toByteArray();
        return buffer;
    }

    public static String byte2File(byte[] buf, int offset, int length, String filePath, String fileName) throws FileNotFoundException, IOException {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        String filePathAbs = new StringBuffer(filePath).append(File.separator).append(fileName).toString();
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) dir.mkdirs();
            file = new File(filePathAbs);//filePath + File.separator + fileName
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf, offset, length);
        } finally {
            if (null != bos) bos.close();
            if (null != fos) fos.close();
        }
        return filePathAbs;
    }

    public static String byte2File(byte[] buf, int offset, int length, String filePath) throws FileNotFoundException, IOException {
        File file = new File(filePath);

        BufferedOutputStream bos = null;
        FileOutputStream fos = null;

        try {
            if (file.exists()) file.delete();
            else if (!file.getParentFile().exists()) file.getParentFile().mkdirs();

            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf, offset, length);
        } finally {
            if (null != bos) bos.close();
            if (null != fos) fos.close();
        }

        return filePath;
    }

    public static String is2File(InputStream is, String filepath) throws FileNotFoundException, IOException {
        File file = new File(filepath);
        // 输出的文件流
        OutputStream os = null;
        try {
            if (file.exists()) file.delete();
            else if (!file.getParentFile().exists()) file.getParentFile().mkdirs();

            // 1K的数据缓冲
            byte[] bs = new byte[1024];
            // 读取到的数据长度
            int len;
            os = new FileOutputStream(filepath);
            // 开始读取
            while ((len = is.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
            //Logger.w(filepath);
        } finally {
            // 完毕，关闭所有链接
            if (null != os) os.close();
            if (null != is) is.close();
        }

        return filepath;
    }


//    /**
//     * 获取文件指定文件的指定单位的大小
//     *
//     * @param filePath 文件路径
//     * @param sizeType 获取大小的类型1为B、2为KB、3为MB、4为GB
//     * @return double值的大小
//     */
//    public static String getFileOrFilesSize(String filePath) {
//        File file = new File(filePath);
//        long blockSize = 0;
//        try {
//            if (file.isDirectory()) {
//                blockSize = getFileSizes(file);
//            } else {
//                blockSize = getFileSize(file);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return formatFileSize(blockSize);
//    }

    /**
     * 调用此方法自动计算指定文件或指定文件夹的大小
     *
     * @param filePath 文件路径
     * @return 计算好的带B、KB、MB、GB的字符串
     */
    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0;
        try {
            if (file.isDirectory()) {
                blockSize = getFileSizes(file);
            } else {
                blockSize = getFileSize(file);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return formatFileSize(blockSize);
    }

    /**
     * 获取指定文件大小
     *
     * @param
     * @return
     * @throws Exception
     */
    public static long getFileSize(File file) throws Exception {
        long size = 0;
        if (file.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            size = fis.available();
        } else {
            file.createNewFile();
        }
        return size;
    }

    /**
     * 获取指定文件夹
     *
     * @param f
     * @return
     * @throws Exception
     */
    public static long getFileSizes(File f) throws Exception {
        long size = 0;
        File flist[] = f.listFiles();
        for (int i = 0; i < flist.length; i++) {
            if (flist[i].isDirectory()) {
                size = size + getFileSizes(flist[i]);
            } else {
                size = size + getFileSize(flist[i]);
            }
        }
        return size;
    }


    public static boolean isInScope(String path, long max, long min) throws Exception {
        return isInScope(getFileSize(new File(path)), max, min);
    }

    public static boolean isInScope(long size, long max, long min) {
        if (size > min && size < max) {
            return true;
        }
        return false;
    }

    /**
     * 转换文件大小
     *
     * @param fileS
     * @return
     */
    public static String formatFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0) {
            return wrongSize;
        }
        if (fileS < 1024) {
            fileSizeString = df.format((double) fileS) + "B";
        } else if (fileS < 1048576) {
            fileSizeString = df.format((double) fileS / 1024) + "KB";
        } else if (fileS < 1073741824) {
            fileSizeString = df.format((double) fileS / 1048576) + "MB";
        } else {
            fileSizeString = df.format((double) fileS / 1073741824) + "GB";
        }
        return fileSizeString;
    }

//    /**
//     * 转换文件大小,指定转换的类型
//     *
//     * @param fileS
//     * @return
//     */
//    public static String formatFileSizeLimit(long fileS) {
//        DecimalFormat df = new DecimalFormat("#.00");
//        String fileSizeString = "";
//        String wrongSize = "0B";
//        if (fileS == 0) {
//            return wrongSize;
//        }
//        if (fileS < 1024) {
//            fileSizeString = df.format((double) fileS) + "B";
//        } else if (fileS < 1048576) {
//            fileSizeString = df.format((double) fileS / 1024) + "KB";
//        } else if (fileS < 1073741824) {
//            fileSizeString = df.format((double) fileS / 1048576) + "MB";
//        } else {
//            fileSizeString = df.format((double) fileS / 1073741824) + "GB";
//        }
//
//        if (fileS < 1048576 * 2) { // 限制图片大小不能大于2MB
//            return fileSizeString;
//        }
//        return null;
//    }


//    public static boolean isResources(String uri) {
//        if (null != uri && uri.startsWith(ContentResolver.SCHEME_ANDROID_RESOURCE)) return true;
//        return false;
//    }
//
//    public static boolean isFile(String uri) {
//        if (null != uri && uri.startsWith(ContentResolver.SCHEME_FILE)) return true;
//        return false;
//    }
//
//    public static Uri getUri(Context ctx, int res) {
//        return Uri.parse(ContentResolver.SCHEME_ANDROID_RESOURCE + "://"
//                + ctx.getResources().getResourcePackageName(res) + "/"
//                + ctx.getResources().getResourceTypeName(res) + "/"
//                + ctx.getResources().getResourceEntryName(res));
//    }

}
