/*
 * Decompiled with CFR 0.152.
 */
package dc.android.arch.present;

import android.content.Context;
import dc.android.arch.present.IBasePresenter;
import dc.android.arch.present.IBaseView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class BasePresenter<V extends IBaseView>
implements IBasePresenter<V> {
    protected Context ctx;
    private Reference<V> mViewRef;

    @Override
    public void attachView(Context ctx, V view) {
        this.ctx = ctx;
        this.mViewRef = new WeakReference<V>(view);
    }

    @Override
    public V getView() {
        return (V)((IBaseView)this.mViewRef.get());
    }

    @Override
    public boolean isViewAttached() {
        return this.mViewRef != null && this.mViewRef.get() != null;
    }

    @Override
    public void detachView() {
        if (this.mViewRef != null) {
            this.mViewRef.clear();
            this.mViewRef = null;
        }
    }
}

