/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.Field;

public class KeyboardUtils {
    private static int sContentViewInvisibleHeightPre;
    private static ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private static OnSoftInputChangedListener onSoftInputChangedListener;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void showSoftInput(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
            view.setFocusable(true);
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
        imm.showSoftInput(view, 2);
    }

    public static void showSoftInput(View view, Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, 2);
    }

    public static void hideSoftInput(Activity activity) {
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(View view, Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void toggleSoftInput(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.toggleSoftInput(2, 0);
    }

    public static boolean isSoftInputVisible(Activity activity) {
        return KeyboardUtils.isSoftInputVisible(activity, 200);
    }

    public static boolean isSoftInputVisible(Activity activity, int minHeightOfSoftInput) {
        return KeyboardUtils.getContentViewInvisibleHeight(activity) >= minHeightOfSoftInput;
    }

    private static int getContentViewInvisibleHeight(Activity activity) {
        View contentView = activity.findViewById(0x1020002);
        Rect outRect = new Rect();
        contentView.getWindowVisibleDisplayFrame(outRect);
        return contentView.getBottom() - outRect.bottom;
    }

    public static void registerSoftInputChangedListener(final Activity activity, OnSoftInputChangedListener listener) {
        int flags = activity.getWindow().getAttributes().flags;
        if ((flags & 0x200) != 0) {
            activity.getWindow().clearFlags(512);
        }
        View contentView = activity.findViewById(0x1020002);
        sContentViewInvisibleHeightPre = KeyboardUtils.getContentViewInvisibleHeight(activity);
        onSoftInputChangedListener = listener;
        onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (onSoftInputChangedListener != null) {
                    int height = KeyboardUtils.getContentViewInvisibleHeight(activity);
                    if (sContentViewInvisibleHeightPre != height) {
                        onSoftInputChangedListener.onSoftInputChanged(height);
                        sContentViewInvisibleHeightPre = height;
                    }
                }
            }
        };
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    @TargetApi(value=16)
    public static void unregisterSoftInputChangedListener(Activity activity) {
        View contentView = activity.findViewById(0x1020002);
        contentView.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
        onSoftInputChangedListener = null;
        onGlobalLayoutListener = null;
    }

    public static void fixSoftInputLeaks(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        String[] strArr = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        for (int i = 0; i < 3; ++i) {
            try {
                Object obj;
                Field declaredField = imm.getClass().getDeclaredField(strArr[i]);
                if (declaredField == null) continue;
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                if ((obj = declaredField.get(imm)) == null || !(obj instanceof View)) continue;
                View view = (View)obj;
                if (view.getContext() == context) {
                    declaredField.set(imm, null);
                    continue;
                }
                return;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    public static void clickBlankArea2HideSoftInput() {
        Log.i((String)"KeyboardUtils", (String)"Please refer to the following code.");
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

