/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import dc.common.Logger;
import java.util.Map;

public class NetUtils {
    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = NetUtils.getNetworkInfo(context);
        if (null != networkInfo) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            return mNetworkInfo;
        }
        return null;
    }

    public static int getNetworkType(Context context) {
        NetworkInfo networkInfo = NetUtils.getNetworkInfo(context);
        if (null != networkInfo) {
            return networkInfo.getType();
        }
        return -1;
    }

    public static boolean isWifi(Context context) {
        return NetUtils.getNetworkType(context) == 1;
    }

    public static boolean isHttps(String url) {
        return null != url && url.startsWith("https");
    }

    public static boolean isHttp(String url) {
        return null != url && url.startsWith("http");
    }

    public static boolean isUrl(String url) {
        return NetUtils.isHttp(url);
    }

    public static String parseGetUrl(String url, Map<String, String> map) {
        StringBuffer sb = new StringBuffer(url);
        for (String key : map.keySet()) {
            sb.append("&").append(key).append("=").append(map.get(key));
        }
        Logger.w((String)("parse: " + sb.toString().replaceFirst("&", "?")));
        return sb.toString().replaceFirst("&", "?");
    }

    public static String formatUrl(String url, Object ... str) {
        return String.format(url, str);
    }

    public static String cleanNet(String str) {
        return str.replace("http://", "").replace("www.", "").replace(".com", "").replace(".cn", "").replace("/", "").replace("\\", "").replace(":", "").replace("'", "").replace("\"", "").replaceAll("\\d+", "").replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
    }
}

