/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import dc.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ProcessUtils {
    public static boolean isWorked(Context ctx, String className) {
        ActivityManager myManager = (ActivityManager)ctx.getApplicationContext().getSystemService("activity");
        ArrayList runningService = (ArrayList)myManager.getRunningServices(Integer.MAX_VALUE);
        for (int i = 0; i < runningService.size(); ++i) {
            if (!((ActivityManager.RunningServiceInfo)runningService.get((int)i)).service.getClassName().toString().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static String getProcessName(Context ctx, int pid) {
        ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
        List runningApps = am.getRunningAppProcesses();
        if (runningApps == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
            if (procInfo.pid != pid) continue;
            return procInfo.processName;
        }
        return null;
    }

    public static boolean isAppOnForeground(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(ctx.getPackageName()) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public static boolean isForeground(Activity activity) {
        return ProcessUtils.isForeground((Context)activity, activity.getClass().getName());
    }

    public static boolean isForeground(Context context, String className) {
        ComponentName cpn;
        if (context == null || StringUtils.isEmpty(className)) {
            return false;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List list = am.getRunningTasks(1);
        return list != null && list.size() > 0 && className.equals((cpn = ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity).getClassName());
    }
}

