/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SharePreferencesUtils {
    private Context mContext;
    private static final String SP_NAME = "sp_dc_us";

    public SharePreferencesUtils(Context mContext) {
        this.mContext = mContext;
    }

    public String getSharedPreferencesValue(String key, String defValue) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SP_NAME, 0);
        return sp.getString(key, defValue);
    }

    public Long getSharedPreferencesValue(String key, long defValue) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SP_NAME, 0);
        return sp.getLong(key, defValue);
    }

    public int getSharedPreferencesValue(String key, int defValue) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SP_NAME, 0);
        return sp.getInt(key, defValue);
    }

    public boolean getSharedPreferencesValue(String key) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SP_NAME, 0);
        return sp.getBoolean(key, false);
    }

    public boolean saveSharedPreferencesValue(String key, String value) {
        SharedPreferences preferences = this.mContext.getSharedPreferences(SP_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        if ("del".equals(value)) {
            editor.remove(key);
        } else {
            editor.putString(key, value);
        }
        return editor.commit();
    }

    public boolean saveSharedPreferencesValue(String key, boolean value) {
        SharedPreferences preferences = this.mContext.getSharedPreferences(SP_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        if ("del".equals(value)) {
            editor.remove(key);
        } else {
            editor.putBoolean(key, value);
        }
        return editor.commit();
    }

    public boolean saveSharedPreferencesValue(String key, int value) {
        SharedPreferences preferences = this.mContext.getSharedPreferences(SP_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    public boolean saveSharedPreferencesValue(String key, long value) {
        SharedPreferences preferences = this.mContext.getSharedPreferences(SP_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong(key, value);
        return editor.commit();
    }
}

