package dc.android.arch.observer;

import java.util.ArrayList;
import java.util.List;

/**
 * 默认只需要
 * 实际业务interface&lt;T&gt; extends IBaseSubject&lt;T&gt;即可,在实际业务impl中写相关业务;
 * <p>
 * 此类仅提取通用方法，实际业务impl可 extends此类&lt;T&gt;再implement实际业务interface&lt;T&gt;.
 *
 * @author senrsl
 * @ClassName: AbstractSubject
 * @Package: dc.android.arch.observer
 * @CreateTime: 2019/4/9 4:06 PM
 */
public class BaseSubject<T extends IBaseObserver> implements IBaseSubject<T> {

    protected List<T> list;

    public BaseSubject() {
        list = new ArrayList<>();
    }

    @Override
    public void registerObserver(T observer) {
        list.add(observer);
    }

    @Override
    public void removeObserver(T observer) {
        list.remove(observer);
    }

//    public void notify();

}
