/**
 * Filename:    ProcessUtils.java
 * Description:
 * Copyright:   Copyright (c)2016
 * Company:
 *
 * @author: senRsl senRsl@163.com
 * @version: 1.0
 * Create at:   2016年3月5日 下午7:13:29
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016年3月5日   senRsl      1.0         1.0 Version
 */
package dc.android.common.utils;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManager.RunningServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import dc.common.utils.StringUtils;

/**
 * @author senrsl
 */
public class ProcessUtils {

    /**
     * 服务是否运行
     *
     * @param ctx
     * @param className
     * @return
     */
    public static boolean isWorked(Context ctx, String className) {
        ActivityManager myManager = (ActivityManager) ctx
                .getApplicationContext().getSystemService(
                        Context.ACTIVITY_SERVICE);
        ArrayList<RunningServiceInfo> runningService = (ArrayList<RunningServiceInfo>) myManager
                .getRunningServices(Integer.MAX_VALUE);
        for (int i = 0; i < runningService.size(); i++) {
            if (runningService.get(i).service.getClassName().toString()
                    .equals(className)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 获取进程名
     *
     * @param ctx
     * @param pid
     * @return
     */
    public static String getProcessName(Context ctx, int pid) {
        ActivityManager am = (ActivityManager) ctx.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningAppProcessInfo> runningApps = am.getRunningAppProcesses();
        if (runningApps == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo procInfo : runningApps) {
            if (procInfo.pid == pid) {
                return procInfo.processName;
            }
        }
        return null;
    }

    /**
     * 应用是否在前台
     *
     * @param ctx
     * @return
     */
    public static boolean isAppOnForeground(Context ctx) {
        ActivityManager activityManager = (ActivityManager) ctx.getSystemService(Context.ACTIVITY_SERVICE);
        // Returns a list of application processes that are running on the
        // device
        List<ActivityManager.RunningAppProcessInfo> appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null)
            return false;
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            // The name of the process that this object is associated with.
            if (appProcess.processName.equals(ctx.getPackageName())
                    /**
                     * 可以根据importance的不同来判断前台或后台 RunningAppProcessInfo
                     * 里面的常量IMOPORTANCE就是上面所说的前台后台
                     * ，其实IMOPORTANCE是表示这个app进程的重要性，因为系统回收时候，会
                     * public static final int IMPORTANCE_EMPTY = 500//空进程
                     * public static final intIMPORTANCE_FOREGROUND = 100//在屏幕最前端、可获取到焦点
                     * 可理解为Activity生命周期的OnResume();
                     * public static final int IMPORTANCE_SERVICE = 300//在服务中
                     * public static final int IMPORTANCE_VISIBLE = 200//在屏幕前端、获取不到焦点可理解为
                     * Activity生命周期的OnStart()
                     */
                    && appProcess.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断某个界面是否在前台
     *
     * @param activity 要判断的Activity
     * @return 是否在前台显示
     */
    public static boolean isForeground(Activity activity) {
        return isForeground(activity, activity.getClass().getName());
    }

    /**
     * 判断某个界面是否在前台
     *
     * @param context   Context
     * @param className 界面的类名
     * @return 是否在前台显示
     */
    public static boolean isForeground(Context context, String className) {
        if (context == null || StringUtils.isEmpty(className))
            return false;
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        List<ActivityManager.RunningTaskInfo> list = am.getRunningTasks(1);
        if (list != null && list.size() > 0) {
            ComponentName cpn = list.get(0).topActivity;
            if (className.equals(cpn.getClassName()))
                return true;
        }
        return false;
    }

}
