package dc.android.common.utils;

import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

/**
 * source bridge
 * @author senrsl
 * @ClassName: ScreenUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2019/1/29 3:53 PM
 */
public class ScreenUtils {

    public static int getDisplayWidth(Context ctx) {
        return getDisplayPoint(ctx).x;
    }

    public static int getDisplayHeight(Context ctx) {
        return getDisplayPoint(ctx).y;
    }

    public static Point getDisplayPoint(Context ctx) {
        WindowManager wm = (WindowManager) ctx.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        return point;
    }

    public static DisplayMetrics getDisplayMetrics(Context ctx) {
        WindowManager wm = (WindowManager) ctx.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

}
