/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"MissingPermission"})
public class GetDeviceInfoUtils {
    Context ctx;

    public GetDeviceInfoUtils(Context context) {
        this.ctx = context;
    }

    public String getInfo() {
        StringBuilder strLog = new StringBuilder();
        try {
            String appName = this.getAppName();
            strLog.append("\u5e94\u7528\u540d\u79f0:" + appName + "\r\n");
            String packName = this.getPackName();
            strLog.append("\u5e94\u7528\u5305\u540d\u79f0:" + packName + "\r\n");
            String verName = this.getVerName(packName);
            strLog.append("\u5e94\u7528\u7248\u672c\u540d\u79f0:" + verName + "\r\n");
            int verCode = this.getVerCode(packName);
            strLog.append("\u5e94\u7528\u7248\u672c\u53f7:" + verCode + "\r\n");
            long installTime = this.getInstallTime(packName);
            strLog.append("\u5b89\u88c5\u65f6\u95f4:" + this.timestamp2String(installTime) + "\r\n");
            long updateTime = this.getUpgradeTime(packName);
            strLog.append("\u66f4\u65b0\u65f6\u95f4:" + this.timestamp2String(updateTime) + "\r\n");
            String model = this.getPhoneModel();
            strLog.append("\u624b\u673a\u578b\u53f7:" + model + "\r\n");
            String phoneNum = this.getLineNum();
            strLog.append("\u624b\u673a\u53f7\u7801:" + phoneNum + "\r\n");
            String imsi = this.getSubscriberId();
            strLog.append("IMSI:" + imsi + "\r\n");
            String devID = this.getDeviceID();
            strLog.append("\u8bbe\u5907ID:" + devID + "\r\n");
            String sim = this.getSim();
            strLog.append("SIM\u5361\u53f7:" + sim + "\r\n");
            SCell cellInfo = this.getCellInfo();
            String strCell = "";
            if (cellInfo != null) {
                strCell = cellInfo.toJSON().toString();
            }
            strLog.append("\u57fa\u7ad9\u4fe1\u606f:" + strCell + "\r\n");
            String mac = this.getMac();
            strLog.append("Mac\u5730\u5740:" + mac);
        }
        catch (Exception e) {
            e.printStackTrace();
            strLog.append("error:");
            strLog.append(e.getMessage());
        }
        return strLog.toString();
    }

    public String getPackName() {
        return this.ctx.getPackageName();
    }

    public String getVerName(String packName) {
        String verName = "";
        try {
            verName = this.ctx.getPackageManager().getPackageInfo((String)packName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return verName;
    }

    public int getVerCode(String packName) {
        int versionCode = 0;
        try {
            versionCode = this.ctx.getPackageManager().getPackageInfo((String)packName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return versionCode;
    }

    public String getAppName() {
        String appName = "";
        try {
            PackageManager packManager = this.ctx.getPackageManager();
            ApplicationInfo appInfo = this.ctx.getApplicationInfo();
            appName = (String)packManager.getApplicationLabel(appInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return appName;
    }

    public long getInstallTime(String pkgName) {
        long installTime = 0L;
        try {
            installTime = this.ctx.getPackageManager().getPackageInfo((String)pkgName, (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return installTime;
    }

    public long getUpgradeTime(String pkgName) {
        long time = 0L;
        try {
            time = this.ctx.getPackageManager().getPackageInfo((String)pkgName, (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return time;
    }

    private String timestamp2String(long timestamp) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(timestamp));
    }

    public String getPhoneModel() {
        return Build.MODEL;
    }

    public String getLineNum() {
        String strResult = "";
        TelephonyManager telephonyManager = (TelephonyManager)this.ctx.getSystemService("phone");
        if (telephonyManager != null) {
            strResult = telephonyManager.getLine1Number();
        }
        return strResult;
    }

    public String getSubscriberId() {
        String strResult = "";
        TelephonyManager telephonyManager = (TelephonyManager)this.ctx.getSystemService("phone");
        if (telephonyManager != null) {
            strResult = telephonyManager.getSubscriberId();
        }
        return strResult;
    }

    public String getDeviceID() {
        String strResult = null;
        TelephonyManager telephonyManager = (TelephonyManager)this.ctx.getSystemService("phone");
        if (telephonyManager != null) {
            strResult = telephonyManager.getDeviceId();
        }
        if (strResult == null) {
            strResult = Settings.Secure.getString((ContentResolver)this.ctx.getContentResolver(), (String)"android_id");
        }
        return strResult;
    }

    public String getSim() {
        String strResult = "";
        TelephonyManager telephonyManager = (TelephonyManager)this.ctx.getSystemService("phone");
        if (telephonyManager != null) {
            strResult = telephonyManager.getSimSerialNumber();
        }
        return strResult;
    }

    public String getMac() {
        WifiManager wifiManager = (WifiManager)this.ctx.getSystemService("wifi");
        if (wifiManager != null) {
            WifiInfo wi = wifiManager.getConnectionInfo();
            return wi.getMacAddress();
        }
        return null;
    }

    public SCell getCellInfo() {
        SCell cell = new SCell();
        TelephonyManager tm = null;
        try {
            tm = (TelephonyManager)this.ctx.getSystemService("phone");
        }
        catch (Exception e) {
            return null;
        }
        String IMSI = tm.getSubscriberId();
        if (IMSI != null) {
            if (IMSI.startsWith("46000") || IMSI.startsWith("46002")) {
                cell.NETWORK_TYPE = "CHINA MOBILE";
                GsmCellLocation location = (GsmCellLocation)tm.getCellLocation();
                if (location == null) {
                    cell = null;
                } else {
                    String operator = tm.getNetworkOperator();
                    if (operator.length() > 4) {
                        int mcc = Integer.parseInt(operator.substring(0, 3));
                        int mnc = Integer.parseInt(operator.substring(3));
                        int cid = location.getCid();
                        int lac = location.getLac();
                        cell.MCC = mcc;
                        cell.MNC = mnc;
                        cell.LAC = lac;
                        cell.CID = cid;
                    } else {
                        cell = null;
                    }
                }
            } else if (IMSI.startsWith("46001")) {
                cell.NETWORK_TYPE = "CHINA UNICOM";
                GsmCellLocation location = (GsmCellLocation)tm.getCellLocation();
                if (location == null) {
                    cell = null;
                } else {
                    String operator = tm.getNetworkOperator();
                    if (operator.length() > 4) {
                        int mcc = Integer.parseInt(operator.substring(0, 3));
                        int mnc = Integer.parseInt(operator.substring(3));
                        int cid = location.getCid();
                        int lac = location.getLac();
                        cell.MCC = mcc;
                        cell.MNC = mnc;
                        cell.LAC = lac;
                        cell.CID = cid;
                    } else {
                        cell = null;
                    }
                }
            } else if (IMSI.startsWith("46003")) {
                cell.NETWORK_TYPE = "CHINA TELECOM";
                CdmaCellLocation location = (CdmaCellLocation)tm.getCellLocation();
                if (location == null) {
                    cell = null;
                } else {
                    String operator = tm.getNetworkOperator();
                    if (operator.length() > 4) {
                        int mcc = Integer.parseInt(operator.substring(0, 3));
                        int mnc = Integer.parseInt(operator.substring(3));
                        int cid = location.getBaseStationId();
                        int lac = location.getNetworkId();
                        cell.MCC = mcc;
                        cell.MNC = mnc;
                        cell.LAC = lac;
                        cell.CID = cid;
                    } else {
                        cell = null;
                    }
                }
            } else {
                cell = null;
            }
        } else {
            cell = null;
        }
        return cell;
    }

    public String getDeviceInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("\u4e3b\u677f\uff1a " + Build.BOARD);
        sb.append("\n\u7cfb\u7edf\u542f\u52a8\u7a0b\u5e8f\u7248\u672c\u53f7\uff1a " + Build.BOOTLOADER);
        sb.append("\n\u7cfb\u7edf\u5b9a\u5236\u5546\uff1a " + Build.BRAND);
        sb.append("\ncpu\u6307\u4ee4\u96c6\uff1a " + Build.CPU_ABI);
        sb.append("\ncpu\u6307\u4ee4\u96c62 " + Build.CPU_ABI2);
        sb.append("\n\u8bbe\u7f6e\u53c2\u6570\uff1a " + Build.DEVICE);
        sb.append("\n\u663e\u793a\u5c4f\u53c2\u6570\uff1a" + Build.DISPLAY);
        sb.append("\n\u65e0\u7ebf\u7535\u56fa\u4ef6\u7248\u672c\uff1a" + Build.getRadioVersion());
        sb.append("\n\u786c\u4ef6\u8bc6\u522b\u7801\uff1a " + Build.FINGERPRINT);
        sb.append("\n\u786c\u4ef6\u540d\u79f0\uff1a " + Build.HARDWARE);
        sb.append("\nHOST: " + Build.HOST);
        sb.append("\nBuild.ID);" + Build.ID);
        sb.append("\n\u786c\u4ef6\u5236\u9020\u5546\uff1a " + Build.MANUFACTURER);
        sb.append("\n\u7248\u672c\uff1a " + Build.MODEL);
        sb.append("\n\u786c\u4ef6\u5e8f\u5217\u53f7\uff1a " + Build.SERIAL);
        sb.append("\n\u624b\u673a\u5236\u9020\u5546\uff1a " + Build.PRODUCT);
        sb.append("\n\u63cf\u8ff0Build\u7684\u6807\u7b7e\uff1a " + Build.TAGS);
        sb.append("\nTIME: " + Build.TIME);
        sb.append("\n\u7248\u672c\u7c7b\u578b" + Build.TYPE);
        sb.append("\nUSER: " + Build.USER);
        sb.append("\n\u5f53\u524d\u5f00\u53d1\u4ee3\u53f7\uff1a" + Build.VERSION.CODENAME);
        sb.append("\n\u6e90\u7801\u63a7\u5236\u7248\u672c\u53f7\uff1a" + Build.VERSION.INCREMENTAL);
        sb.append("\n\u7528\u6237\u53ef\u89c1\u7684\u7248\u672c\u5b57\u7b26\u4e32\uff1a" + Build.VERSION.RELEASE);
        sb.append("\nSDK\u7248\u672c\u53f7\uff1a" + Build.VERSION.SDK_INT);
        return sb.toString();
    }

    class SCell {
        public String NETWORK_TYPE;
        public int MCC;
        public int MNC;
        public int LAC;
        public int CID;

        SCell() {
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            json.put("network_type", (Object)this.NETWORK_TYPE);
            json.put("mcc", this.MCC);
            json.put("MNC", this.MNC);
            json.put("LAC", this.LAC);
            json.put("CID", this.CID);
            return json;
        }
    }
}

