/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.content.Context;
import android.content.res.XmlResourceParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlParseUtils {
    public static void parseXml(Context ctx, int xmlId, String xmlHead, Map<String, String> map) throws XmlPullParserException, IOException {
        XmlResourceParser parser = ctx.getResources().getXml(xmlId);
        while (parser.getEventType() != 1) {
            String nodeName;
            if (parser.getEventType() == 2 && !xmlHead.equals(nodeName = parser.getName())) {
                map.put(nodeName, parser.nextText());
            }
            parser.next();
        }
    }

    public static void parseXml(InputStream inputstream, String fileHead, String dataHead, Map<String, String> map) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = xmlPullParserFactory.newPullParser();
        parser.setInput(inputstream, "UTF-8");
        int eventType = parser.getEventType();
        while (1 != eventType) {
            switch (eventType) {
                case 0: {
                    break;
                }
                case 2: {
                    String nodeName = parser.getName();
                    if (nodeName.equals(fileHead)) break;
                    if (nodeName.equals(dataHead)) {
                        int count = parser.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String key = parser.getAttributeName(i);
                            String value = parser.getAttributeValue(i);
                            map.put(key, value);
                        }
                        break;
                    }
                    String value = parser.nextText();
                    map.put(parser.getName(), value);
                    break;
                }
                case 3: {
                    break;
                }
            }
            eventType = parser.next();
        }
    }
}

