/*
 * Decompiled with CFR 0.152.
 */
package dc.android.manager;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.Base64;
import dc.android.common.BridgeContext;
import dc.android.common.NetContext;
import dc.android.common.StatContext;
import dc.android.common.net.WebUtils;
import dc.common.Logger;
import dc.common.utils.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public class SendManager {
    private Context ctx;
    private Callback cb;

    public SendManager(Context ctx, Callback cb) {
        this.ctx = ctx;
        this.cb = cb;
    }

    public void send(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        new Thread(() -> {
            try {
                JSONObject jo = new JSONObject();
                jo.put(StatContext.KEY_HOOKS, (Object)msg);
                WebUtils.doPostAsJson((String)StatContext.URI_HOOKS, (String)jo.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cb.onErr(e.getMessage());
            }
        }).start();
    }

    public void sendFile(File file, String msg) {
        if (null == file || !file.exists()) {
            return;
        }
        new Thread(() -> {
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("token", StatContext.KEY_SLACK_TOKEN);
                map.put("channels", StatContext.KEY_SLACK_CHANNELS);
                map.put("initial_comment", msg);
                map.put(file.getName(), file);
                WebUtils.doPost((String)NetContext.CONTENT_TYPE_FORM_DATA, (String)StatContext.URI_SLACK_UPLOAD, null, map);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cb.onErr(e.getMessage());
            }
        }).start();
    }

    public void sendDingTalk(String type, String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        new Thread(() -> {
            try {
                JSONObject jo = new JSONObject();
                jo.put(StatContext.KEY_DING_TYPE, (Object)type);
                if (StatContext.KEY_DING_TYPE_TEXT.equals(type)) {
                    JSONObject joContent = new JSONObject();
                    joContent.put(StatContext.KEY_DING_CONTENT, (Object)msg);
                    jo.put(StatContext.KEY_DING_TYPE_TEXT, (Object)joContent);
                } else if (StatContext.KEY_DING_TYPE_MARKDOWN.equals(type)) {
                    JSONObject joContent = new JSONObject();
                    joContent.put(StatContext.KEY_DING_TITLE, (Object)",");
                    joContent.put(StatContext.KEY_DING_TEXT, (Object)msg);
                    jo.put(StatContext.KEY_DING_TYPE_MARKDOWN, (Object)joContent);
                }
                Logger.w((String)jo.toString());
                WebUtils.doPostAsJson((String)this.getDingTalkUrl(), (String)jo.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cb.onErr(e.getMessage());
            }
        }).start();
    }

    @TargetApi(value=8)
    private String getDingTalkUrl() throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        Long timestamp = System.currentTimeMillis();
        String stringToSign = StringUtils.sub((Object[])new Object[]{timestamp, BridgeContext.LINE, StatContext.KEY_DING_SEC});
        Mac mac = Mac.getInstance(StatContext.KEY_DING_SIGN);
        mac.init(new SecretKeySpec(StatContext.KEY_DING_SEC.getBytes("UTF-8"), StatContext.KEY_DING_SIGN));
        byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        String sign = URLEncoder.encode(new String(Base64.encode((byte[])signData, (int)2)), "UTF-8");
        return String.format(StringUtils.sub((Object[])new Object[]{StatContext.URI_DING, StatContext.URI_DING_FORMAT}), timestamp, sign);
    }

    public static interface Callback {
        public void onErr(String var1);
    }
}

